/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Stirrup.
 *
 * Herodotus Stirrup is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Stirrup is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.oauth2.authentication.provider;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.oidc.OidcClientRegistration;
import org.springframework.security.oauth2.server.authorization.oidc.converter.OidcClientRegistrationRegisteredClientConverter;
import org.springframework.security.oauth2.server.authorization.settings.ClientSettings;

import java.util.List;

/**
 * <p>Description: OidcClientRegistration 转 RegisteredClient 转换器</p>
 *
 * @author : gengwei.zheng
 * @date : 2024/5/16 16:18
 */
public class OidcClientRegistrationToRegisteredClientConverter implements Converter<OidcClientRegistration, RegisteredClient> {

    private final List<String> clientMetadata;
    private final OidcClientRegistrationRegisteredClientConverter delegate;

    public OidcClientRegistrationToRegisteredClientConverter(List<String> clientMetadata) {
        this.clientMetadata = clientMetadata;
        this.delegate = new OidcClientRegistrationRegisteredClientConverter();
    }

    @Override
    public RegisteredClient convert(OidcClientRegistration oidcClientRegistration) {
        RegisteredClient registeredClient = this.delegate.convert(oidcClientRegistration);
        ClientSettings.Builder clientSettingsBuilder = ClientSettings.withSettings(registeredClient.getClientSettings().getSettings());
        if (CollectionUtils.isNotEmpty(this.clientMetadata)) {
            oidcClientRegistration.getClaims().forEach((claim, value) -> {
                if (this.clientMetadata.contains(claim)) {
                    clientSettingsBuilder.setting(claim, value);
                }
            });
        }

        return RegisteredClient.from(registeredClient)
                .clientSettings(clientSettingsBuilder.build())
                .build();
    }
}
