/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.oauth2.authentication.utils;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class OAuth2EndpointUtils {
    public static final String ACCESS_TOKEN_REQUEST_ERROR_URI = "https://datatracker.ietf.org/doc/html/rfc6749#section-5.2";

    private OAuth2EndpointUtils() {
    }

    public static MultiValueMap<String, String> getParameters(HttpServletRequest request) {
        Map parameterMap = request.getParameterMap();
        LinkedMultiValueMap parameters = new LinkedMultiValueMap(parameterMap.size());
        parameterMap.forEach((arg_0, arg_1) -> OAuth2EndpointUtils.lambda$getParameters$0((MultiValueMap)parameters, arg_0, arg_1));
        return parameters;
    }

    public static Map<String, Object> getParametersIfMatchesAuthorizationCodeGrantRequest(HttpServletRequest request, String ... exclusions) {
        if (!OAuth2EndpointUtils.matchesAuthorizationCodeGrantRequest(request)) {
            return Collections.emptyMap();
        }
        return OAuth2EndpointUtils.getParameters(request, exclusions);
    }

    public static Map<String, Object> getParameters(HttpServletRequest request, String ... exclusions) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(OAuth2EndpointUtils.getParameters(request).toSingleValueMap());
        for (String exclusion : exclusions) {
            parameters.remove(exclusion);
        }
        return parameters;
    }

    public static boolean matchesClientCredentialsGrantRequest(HttpServletRequest request) {
        return AuthorizationGrantType.CLIENT_CREDENTIALS.getValue().equals(request.getParameter("grant_type"));
    }

    public static boolean matchesAuthorizationCodeGrantRequest(HttpServletRequest request) {
        return AuthorizationGrantType.AUTHORIZATION_CODE.getValue().equals(request.getParameter("grant_type")) && request.getParameter("code") != null;
    }

    public static boolean matchesPkceTokenRequest(HttpServletRequest request) {
        return OAuth2EndpointUtils.matchesAuthorizationCodeGrantRequest(request) && request.getParameter("code_verifier") != null;
    }

    public static void throwError(String errorCode, String parameterName) {
        OAuth2EndpointUtils.throwError(errorCode, parameterName, ACCESS_TOKEN_REQUEST_ERROR_URI);
    }

    public static void throwError(String errorCode, String parameterName, String errorUri) {
        OAuth2Error error = new OAuth2Error(errorCode, "OAuth 2.0 Parameter: " + parameterName, errorUri);
        throw new OAuth2AuthenticationException(error);
    }

    private static boolean checkRequired(MultiValueMap<String, String> parameters, String parameterName, String parameterValue) {
        return !StringUtils.hasText((String)parameterValue) || ((List)parameters.get((Object)parameterName)).size() != 1;
    }

    private static boolean checkOptional(MultiValueMap<String, String> parameters, String parameterName, String parameterValue) {
        return StringUtils.hasText((String)parameterValue) && ((List)parameters.get((Object)parameterName)).size() != 1;
    }

    public static String checkParameter(MultiValueMap<String, String> parameters, String parameterName, boolean isRequired, String errorCode, String errorUri) {
        String value = (String)parameters.getFirst((Object)parameterName);
        if (isRequired) {
            if (OAuth2EndpointUtils.checkRequired(parameters, parameterName, value)) {
                OAuth2EndpointUtils.throwError(errorCode, parameterName, errorUri);
            }
        } else if (OAuth2EndpointUtils.checkOptional(parameters, parameterName, value)) {
            OAuth2EndpointUtils.throwError(errorCode, parameterName, errorUri);
        }
        return value;
    }

    public static String checkRequiredParameter(MultiValueMap<String, String> parameters, String parameterName, String errorCode, String errorUri) {
        return OAuth2EndpointUtils.checkParameter(parameters, parameterName, true, errorCode, errorUri);
    }

    public static String checkRequiredParameter(MultiValueMap<String, String> parameters, String parameterName, String errorCode) {
        return OAuth2EndpointUtils.checkRequiredParameter(parameters, parameterName, errorCode, ACCESS_TOKEN_REQUEST_ERROR_URI);
    }

    public static String checkRequiredParameter(MultiValueMap<String, String> parameters, String parameterName) {
        return OAuth2EndpointUtils.checkRequiredParameter(parameters, parameterName, "invalid_request");
    }

    public static String checkOptionalParameter(MultiValueMap<String, String> parameters, String parameterName, String errorCode, String errorUri) {
        return OAuth2EndpointUtils.checkParameter(parameters, parameterName, false, errorCode, errorUri);
    }

    public static String checkOptionalParameter(MultiValueMap<String, String> parameters, String parameterName, String errorCode) {
        return OAuth2EndpointUtils.checkOptionalParameter(parameters, parameterName, errorCode, ACCESS_TOKEN_REQUEST_ERROR_URI);
    }

    public static String checkOptionalParameter(MultiValueMap<String, String> parameters, String parameterName) {
        return OAuth2EndpointUtils.checkOptionalParameter(parameters, parameterName, "invalid_request");
    }

    private static /* synthetic */ void lambda$getParameters$0(MultiValueMap parameters, String key, String[] values) {
        for (String value : values) {
            parameters.add((Object)key, (Object)value);
        }
    }
}

