/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.oauth2.authentication.response;

import cn.herodotus.stirrup.core.autoconfigure.oauth2.definition.SecurityGlobalExceptionHandler;
import cn.herodotus.stirrup.core.definition.domain.Result;
import cn.herodotus.stirrup.oauth2.authentication.utils.OAuth2EndpointUtils;
import cn.herodotus.stirrup.web.core.servlet.utils.ResponseUtils;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.http.converter.OAuth2ErrorHttpMessageConverter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.util.MultiValueMap;

public class OAuth2AuthenticationFailureResponseHandler
implements AuthenticationFailureHandler {
    private final HttpMessageConverter<OAuth2Error> errorHttpResponseConverter = new OAuth2ErrorHttpMessageConverter();

    /*
     * Enabled aggressive block sorting
     */
    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        MultiValueMap<String, String> parameters = OAuth2EndpointUtils.getParameters(request);
        String deviceCode = (String)parameters.getFirst((Object)"device_code");
        if (exception instanceof OAuth2AuthenticationException) {
            OAuth2AuthenticationException oauth2Exception = (OAuth2AuthenticationException)exception;
            if (StringUtils.isNotBlank((CharSequence)deviceCode)) {
                OAuth2Error error = oauth2Exception.getError();
                ServletServerHttpResponse httpResponse = new ServletServerHttpResponse(response);
                httpResponse.setStatusCode((HttpStatusCode)HttpStatus.BAD_REQUEST);
                this.errorHttpResponseConverter.write((Object)error, null, (HttpOutputMessage)httpResponse);
                return;
            }
        }
        Result result = SecurityGlobalExceptionHandler.resolveSecurityException((Exception)exception, (String)request.getRequestURI());
        response.setStatus(result.getStatus());
        ResponseUtils.renderJson((HttpServletResponse)response, (Object)result);
    }
}

