/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.oauth2.authentication.response;

import cn.herodotus.stirrup.oauth2.core.exception.AccountEndpointLimitedException;
import cn.herodotus.stirrup.oauth2.core.exception.SessionExpiredException;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.security.authentication.AccountExpiredException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.authentication.DefaultAuthenticationEventPublisher;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;

public class DefaultOAuth2AuthenticationEventPublisher
extends DefaultAuthenticationEventPublisher {
    public DefaultOAuth2AuthenticationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        super(applicationEventPublisher);
    }

    public void publishAuthenticationFailure(AuthenticationException exception, Authentication authentication) {
        super.publishAuthenticationFailure(this.convert(exception), authentication);
    }

    private AuthenticationException convert(AuthenticationException exception) {
        if (exception instanceof OAuth2AuthenticationException) {
            OAuth2AuthenticationException authenticationException = (OAuth2AuthenticationException)exception;
            OAuth2Error error = authenticationException.getError();
            return switch (error.getErrorCode()) {
                case "AccountExpiredException" -> new AccountExpiredException(exception.getMessage(), exception.getCause());
                case "CredentialsExpiredException" -> new CredentialsExpiredException(exception.getMessage(), exception.getCause());
                case "DisabledException" -> new DisabledException(exception.getMessage(), exception.getCause());
                case "LockedException" -> new LockedException(exception.getMessage(), exception.getCause());
                case "AccountEndpointLimitedException" -> new AccountEndpointLimitedException(exception.getMessage(), exception.getCause());
                case "UsernameNotFoundException" -> new UsernameNotFoundException(exception.getMessage(), exception.getCause());
                case "SessionExpiredException" -> new SessionExpiredException(exception.getMessage(), exception.getCause());
                default -> new BadCredentialsException(exception.getMessage(), exception.getCause());
            };
        }
        return exception;
    }
}

