/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.oauth2.authentication.provider;

import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.oidc.OidcClientRegistration;
import org.springframework.security.oauth2.server.authorization.oidc.converter.RegisteredClientOidcClientRegistrationConverter;
import org.springframework.security.oauth2.server.authorization.settings.ClientSettings;

public class RegisteredClientToOidcClientRegistrationConverter
implements Converter<RegisteredClient, OidcClientRegistration> {
    private final List<String> clientMetadata;
    private final RegisteredClientOidcClientRegistrationConverter delegate;

    public RegisteredClientToOidcClientRegistrationConverter(List<String> clientMetadata) {
        this.clientMetadata = clientMetadata;
        this.delegate = new RegisteredClientOidcClientRegistrationConverter();
    }

    public OidcClientRegistration convert(RegisteredClient registeredClient) {
        OidcClientRegistration clientRegistration = this.delegate.convert(registeredClient);
        HashMap claims = new HashMap(clientRegistration.getClaims());
        if (CollectionUtils.isNotEmpty(this.clientMetadata)) {
            ClientSettings clientSettings = registeredClient.getClientSettings();
            claims.putAll(this.clientMetadata.stream().filter(metadata -> clientSettings.getSetting(metadata) != null).collect(Collectors.toMap(Function.identity(), arg_0 -> ((ClientSettings)clientSettings).getSetting(arg_0))));
        }
        return OidcClientRegistration.withClaims(claims).build();
    }
}

