/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.oauth2.authentication.provider;

import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.oidc.OidcClientRegistration;
import org.springframework.security.oauth2.server.authorization.oidc.converter.OidcClientRegistrationRegisteredClientConverter;
import org.springframework.security.oauth2.server.authorization.settings.ClientSettings;

public class OidcClientRegistrationToRegisteredClientConverter
implements Converter<OidcClientRegistration, RegisteredClient> {
    private final List<String> clientMetadata;
    private final OidcClientRegistrationRegisteredClientConverter delegate;

    public OidcClientRegistrationToRegisteredClientConverter(List<String> clientMetadata) {
        this.clientMetadata = clientMetadata;
        this.delegate = new OidcClientRegistrationRegisteredClientConverter();
    }

    public RegisteredClient convert(OidcClientRegistration oidcClientRegistration) {
        RegisteredClient registeredClient = this.delegate.convert(oidcClientRegistration);
        ClientSettings.Builder clientSettingsBuilder = ClientSettings.withSettings((Map)registeredClient.getClientSettings().getSettings());
        if (CollectionUtils.isNotEmpty(this.clientMetadata)) {
            oidcClientRegistration.getClaims().forEach((claim, value) -> {
                if (this.clientMetadata.contains(claim)) {
                    clientSettingsBuilder.setting(claim, value);
                }
            });
        }
        return RegisteredClient.from((RegisteredClient)registeredClient).clientSettings(clientSettingsBuilder.build()).build();
    }
}

