/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.oauth2.authentication.provider;

import cn.herodotus.stirrup.core.foundation.enums.AccountCategory;
import cn.herodotus.stirrup.oauth2.authentication.provider.AbstractAuthenticationConverter;
import cn.herodotus.stirrup.oauth2.authentication.provider.OAuth2SocialCredentialsAuthenticationToken;
import cn.herodotus.stirrup.oauth2.authentication.utils.OAuth2EndpointUtils;
import cn.herodotus.stirrup.oauth2.core.constants.HerodotusGrantType;
import cn.herodotus.stirrup.web.servlet.crypto.HttpCryptoProcessor;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.security.core.Authentication;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class OAuth2SocialCredentialsAuthenticationConverter
extends AbstractAuthenticationConverter {
    public OAuth2SocialCredentialsAuthenticationConverter(HttpCryptoProcessor httpCryptoProcessor) {
        super(httpCryptoProcessor);
    }

    public Authentication convert(HttpServletRequest request) {
        AccountCategory accountCategory;
        String grantType = request.getParameter("grant_type");
        if (!HerodotusGrantType.SOCIAL.getValue().equals(grantType)) {
            return null;
        }
        MultiValueMap<String, String> parameters = OAuth2EndpointUtils.getParameters(request);
        String scope = OAuth2EndpointUtils.checkOptionalParameter(parameters, "scope");
        String source = OAuth2EndpointUtils.checkRequiredParameter(parameters, "source");
        if (StringUtils.hasText((String)source) && ObjectUtils.isNotEmpty((Object)(accountCategory = AccountCategory.getAccountType((String)source)))) {
            switch (accountCategory.getHandler()) {
                case "PHONE_NUMBER": {
                    OAuth2EndpointUtils.checkRequiredParameter(parameters, "mobile");
                    OAuth2EndpointUtils.checkRequiredParameter(parameters, "code");
                    break;
                }
                case "WECHAT_MINI_APP": {
                    OAuth2EndpointUtils.checkRequiredParameter(parameters, "appId");
                    OAuth2EndpointUtils.checkRequiredParameter(parameters, "sessionKey");
                    OAuth2EndpointUtils.checkRequiredParameter(parameters, "encryptedData");
                    OAuth2EndpointUtils.checkRequiredParameter(parameters, "iv");
                    break;
                }
            }
        }
        return new OAuth2SocialCredentialsAuthenticationToken(this.getClientPrincipal(), this.getRequestedScopes(scope), this.getAdditionalParameters(request, parameters));
    }
}

