/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.oauth2.authentication.provider;

import cn.herodotus.stirrup.oauth2.core.constants.HerodotusGrantType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.lang.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationGrantAuthenticationToken;
import org.springframework.util.Assert;

public class OAuth2ResourceOwnerPasswordAuthenticationToken
extends OAuth2AuthorizationGrantAuthenticationToken {
    private final Set<String> scopes;

    public OAuth2ResourceOwnerPasswordAuthenticationToken(Authentication clientPrincipal, @Nullable Set<String> scopes, @Nullable Map<String, Object> additionalParameters) {
        super(HerodotusGrantType.PASSWORD, clientPrincipal, additionalParameters);
        Assert.notNull((Object)clientPrincipal, (String)"clientPrincipal cannot be null");
        this.scopes = Collections.unmodifiableSet(CollectionUtils.isNotEmpty(scopes) ? new HashSet<String>(scopes) : Collections.emptySet());
    }

    public Set<String> getScopes() {
        return this.scopes;
    }
}

