/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.oauth2.authentication.provider;

import cn.herodotus.stirrup.oauth2.authentication.provider.AbstractAuthenticationProvider;
import cn.herodotus.stirrup.oauth2.authentication.utils.OAuth2AuthenticationProviderUtils;
import java.security.Principal;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2RefreshToken;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationCode;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.OAuth2TokenType;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AccessTokenAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2ClientAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.context.AuthorizationServerContextHolder;
import org.springframework.security.oauth2.server.authorization.token.DefaultOAuth2TokenContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenGenerator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class OAuth2AuthorizationCodeAuthenticationProvider
extends AbstractAuthenticationProvider {
    private static final Logger log = LoggerFactory.getLogger(OAuth2AuthorizationCodeAuthenticationProvider.class);
    private static final String ERROR_URI = "https://datatracker.ietf.org/doc/html/rfc6749#section-5.2";
    private static final OAuth2TokenType AUTHORIZATION_CODE_TOKEN_TYPE = new OAuth2TokenType("code");
    private final OAuth2AuthorizationService authorizationService;
    private final OAuth2TokenGenerator<? extends OAuth2Token> tokenGenerator;
    private SessionRegistry sessionRegistry;

    public OAuth2AuthorizationCodeAuthenticationProvider(OAuth2AuthorizationService authorizationService, OAuth2TokenGenerator<? extends OAuth2Token> tokenGenerator) {
        Assert.notNull((Object)authorizationService, (String)"authorizationService cannot be null");
        Assert.notNull(tokenGenerator, (String)"tokenGenerator cannot be null");
        this.authorizationService = authorizationService;
        this.tokenGenerator = tokenGenerator;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        OAuth2Authorization authorization;
        OAuth2AuthorizationCodeAuthenticationToken authorizationCodeAuthentication = (OAuth2AuthorizationCodeAuthenticationToken)authentication;
        OAuth2ClientAuthenticationToken clientPrincipal = OAuth2AuthenticationProviderUtils.getAuthenticatedClientElseThrowInvalidClient((Authentication)authorizationCodeAuthentication);
        RegisteredClient registeredClient = clientPrincipal.getRegisteredClient();
        if (log.isTraceEnabled()) {
            log.trace("Retrieved registered client");
        }
        if ((authorization = this.authorizationService.findByToken(authorizationCodeAuthentication.getCode(), AUTHORIZATION_CODE_TOKEN_TYPE)) == null) {
            throw new OAuth2AuthenticationException("invalid_grant");
        }
        if (log.isTraceEnabled()) {
            log.trace("Retrieved authorization with authorization code");
        }
        OAuth2Authorization.Token authorizationCode = authorization.getToken(OAuth2AuthorizationCode.class);
        OAuth2AuthorizationRequest authorizationRequest = (OAuth2AuthorizationRequest)authorization.getAttribute(OAuth2AuthorizationRequest.class.getName());
        if (!registeredClient.getClientId().equals(authorizationRequest.getClientId())) {
            if (!authorizationCode.isInvalidated()) {
                authorization = OAuth2AuthenticationProviderUtils.invalidate(authorization, (OAuth2AuthorizationCode)authorizationCode.getToken());
                this.authorizationService.save(authorization);
                if (log.isWarnEnabled()) {
                    log.warn("Invalidated authorization code used by registered client {}", (Object)registeredClient.getId());
                }
            }
            throw new OAuth2AuthenticationException("invalid_grant");
        }
        if (StringUtils.hasText((String)authorizationRequest.getRedirectUri()) && !authorizationRequest.getRedirectUri().equals(authorizationCodeAuthentication.getRedirectUri())) {
            throw new OAuth2AuthenticationException("invalid_grant");
        }
        if (!authorizationCode.isActive()) {
            if (authorizationCode.isInvalidated()) {
                OAuth2Authorization.Token token;
                OAuth2Authorization.Token token2 = token = authorization.getRefreshToken() != null ? authorization.getRefreshToken() : authorization.getAccessToken();
                if (token != null) {
                    authorization = OAuth2AuthenticationProviderUtils.invalidate(authorization, token.getToken());
                    this.authorizationService.save(authorization);
                    if (log.isWarnEnabled()) {
                        log.warn("Invalidated authorization token(s) previously issued to registered client {}", (Object)registeredClient.getId());
                    }
                }
            }
            throw new OAuth2AuthenticationException("invalid_grant");
        }
        if (log.isTraceEnabled()) {
            log.trace("Validated token request parameters");
        }
        Authentication principal = (Authentication)authorization.getAttribute(Principal.class.getName());
        DefaultOAuth2TokenContext.Builder tokenContextBuilder = (DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)DefaultOAuth2TokenContext.builder().registeredClient(registeredClient)).principal(principal)).authorizationServerContext(AuthorizationServerContextHolder.getContext())).authorization(authorization)).authorizedScopes(authorization.getAuthorizedScopes())).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE)).authorizationGrant((Authentication)authorizationCodeAuthentication);
        OAuth2Authorization.Builder authorizationBuilder = OAuth2Authorization.from((OAuth2Authorization)authorization);
        OAuth2AccessToken accessToken = this.createOAuth2AccessToken(tokenContextBuilder, authorizationBuilder, this.tokenGenerator, ERROR_URI);
        OAuth2RefreshToken refreshToken = this.creatOAuth2RefreshToken(tokenContextBuilder, authorizationBuilder, this.tokenGenerator, ERROR_URI, clientPrincipal, registeredClient);
        OidcIdToken idToken = this.createOidcIdToken(principal, this.sessionRegistry, tokenContextBuilder, authorizationBuilder, this.tokenGenerator, ERROR_URI, authorizationRequest.getScopes());
        authorization = authorizationBuilder.build();
        authorization = OAuth2AuthenticationProviderUtils.invalidate(authorization, (OAuth2AuthorizationCode)authorizationCode.getToken());
        this.authorizationService.save(authorization);
        if (log.isTraceEnabled()) {
            log.trace("Saved authorization");
        }
        Map<String, Object> additionalParameters = this.idTokenAdditionalParameters(idToken);
        if (log.isTraceEnabled()) {
            log.trace("Authenticated token request");
        }
        OAuth2AccessTokenAuthenticationToken accessTokenAuthenticationToken = new OAuth2AccessTokenAuthenticationToken(registeredClient, (Authentication)clientPrincipal, accessToken, refreshToken, additionalParameters);
        return this.createOAuth2AccessTokenAuthenticationToken(principal, accessTokenAuthenticationToken);
    }

    public void setSessionRegistry(SessionRegistry sessionRegistry) {
        Assert.notNull((Object)sessionRegistry, (String)"sessionRegistry cannot be null");
        this.sessionRegistry = sessionRegistry;
    }

    public boolean supports(Class<?> authentication) {
        return OAuth2AuthorizationCodeAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

