/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.oauth2.authentication.provider;

import cn.herodotus.stirrup.core.foundation.utils.type.ListUtils;
import cn.herodotus.stirrup.oauth2.authentication.utils.OAuth2EndpointUtils;
import cn.herodotus.stirrup.web.core.exception.SessionInvalidException;
import cn.herodotus.stirrup.web.core.servlet.utils.SessionUtils;
import cn.herodotus.stirrup.web.servlet.crypto.HttpCryptoProcessor;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.util.MultiValueMap;

public abstract class AbstractAuthenticationConverter
implements AuthenticationConverter {
    private final HttpCryptoProcessor httpCryptoProcessor;

    public AbstractAuthenticationConverter(HttpCryptoProcessor httpCryptoProcessor) {
        this.httpCryptoProcessor = httpCryptoProcessor;
    }

    protected String[] decrypt(HttpServletRequest request, String sessionId, List<String> parameters) {
        if (SessionUtils.isCryptoEnabled((HttpServletRequest)request, (String)sessionId) && CollectionUtils.isNotEmpty(parameters)) {
            List<String> result = parameters.stream().map(item -> this.decrypt(request, sessionId, (String)item)).toList();
            return ListUtils.toStringArray(result);
        }
        return ListUtils.toStringArray(parameters);
    }

    protected String decrypt(HttpServletRequest request, String sessionId, String parameter) {
        if (SessionUtils.isCryptoEnabled((HttpServletRequest)request, (String)sessionId) && StringUtils.isNotBlank((CharSequence)parameter)) {
            try {
                return this.httpCryptoProcessor.decrypt(sessionId, parameter);
            }
            catch (SessionInvalidException e) {
                OAuth2EndpointUtils.throwError("SessionExpiredException", e.getMessage(), "https://datatracker.ietf.org/doc/html/rfc6749#section-5.2");
            }
        }
        return parameter;
    }

    protected Authentication getClientPrincipal() {
        return SecurityContextHolder.getContext().getAuthentication();
    }

    protected Map<String, Object> getAdditionalParameters(HttpServletRequest request, MultiValueMap<String, String> parameters) {
        String sessionId = SessionUtils.analyseSessionId((HttpServletRequest)request);
        HashMap<String, Object> additionalParameters = new HashMap<String, Object>();
        parameters.forEach((key, value) -> {
            if (!key.equals("grant_type") && !key.equals("scope")) {
                additionalParameters.put((String)key, value.size() == 1 ? this.decrypt(request, sessionId, (String)value.get(0)) : this.decrypt(request, sessionId, (List<String>)value));
            }
        });
        return additionalParameters;
    }

    protected Set<String> getRequestedScopes(String scope) {
        HashSet<String> requestedScopes = null;
        if (org.springframework.util.StringUtils.hasText((String)scope)) {
            requestedScopes = new HashSet<String>(Arrays.asList(org.springframework.util.StringUtils.delimitedListToStringArray((String)scope, (String)" ")));
        }
        return requestedScopes;
    }
}

