/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.oauth2.authentication.customizer;

import cn.herodotus.stirrup.core.identity.domain.AccessPrincipal;
import cn.herodotus.stirrup.core.identity.domain.HerodotusUser;
import cn.herodotus.stirrup.core.identity.service.EnhanceUserDetailsService;
import cn.herodotus.stirrup.core.identity.strategy.StrategyUserDetailsService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class HerodotusUserDetailsService
implements EnhanceUserDetailsService {
    private static final Logger log = LoggerFactory.getLogger(HerodotusUserDetailsService.class);
    private final StrategyUserDetailsService strategyUserDetailsService;

    public HerodotusUserDetailsService(StrategyUserDetailsService strategyUserDetailsService) {
        this.strategyUserDetailsService = strategyUserDetailsService;
    }

    public HerodotusUser loadHerodotusUserBySocial(String source, AccessPrincipal accessPrincipal) throws UsernameNotFoundException {
        HerodotusUser HerodotusUser2 = this.strategyUserDetailsService.findUserDetailsBySocial(StringUtils.toRootUpperCase((String)source), accessPrincipal);
        log.debug("[Herodotus] |- UserDetailsService loaded social user : [{}]", (Object)HerodotusUser2.getUsername());
        return HerodotusUser2;
    }

    public HerodotusUser loadHerodotusUserByUsername(String username) throws UsernameNotFoundException {
        HerodotusUser HerodotusUser2 = this.strategyUserDetailsService.findUserDetailsByUsername(username);
        log.debug("[Herodotus] |- UserDetailsService loaded user : [{}]", (Object)username);
        return HerodotusUser2;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        return this.loadHerodotusUserByUsername(username);
    }
}

