/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.oauth2.authentication.customizer;

import cn.herodotus.stirrup.oauth2.authentication.customizer.AbstractTokenCustomizer;
import java.util.HashMap;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.server.authorization.OAuth2TokenType;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2ClientAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenClaimsContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenClaimsSet;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenCustomizer;

public class HerodotusOpaqueTokenCustomizer
extends AbstractTokenCustomizer
implements OAuth2TokenCustomizer<OAuth2TokenClaimsContext> {
    public void customize(OAuth2TokenClaimsContext context) {
        Authentication authentication;
        OAuth2ClientAuthenticationToken token = null;
        Authentication clientAuthentication = SecurityContextHolder.getContext().getAuthentication();
        if (clientAuthentication instanceof OAuth2ClientAuthenticationToken) {
            token = (OAuth2ClientAuthenticationToken)clientAuthentication;
        }
        if (ObjectUtils.isNotEmpty(token) && token.isAuthenticated() && OAuth2TokenType.ACCESS_TOKEN.equals((Object)context.getTokenType()) && ObjectUtils.isNotEmpty((Object)(authentication = context.getPrincipal()))) {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            this.appendAll(attributes, authentication, context.getAuthorizedScopes());
            OAuth2TokenClaimsSet.Builder tokenClaimSetBuilder = context.getClaims();
            tokenClaimSetBuilder.claims(claims -> claims.putAll(attributes));
        }
    }
}

