/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.oauth2.authentication.customizer;

import cn.herodotus.stirrup.oauth2.authentication.customizer.AbstractTokenCustomizer;
import java.util.HashMap;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.jwt.JwtClaimsSet;
import org.springframework.security.oauth2.server.authorization.OAuth2TokenType;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2ClientAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.token.JwtEncodingContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenCustomizer;

public class HerodotusJwtTokenCustomizer
extends AbstractTokenCustomizer
implements OAuth2TokenCustomizer<JwtEncodingContext> {
    public void customize(JwtEncodingContext context) {
        OAuth2ClientAuthenticationToken token = null;
        Authentication clientAuthentication = SecurityContextHolder.getContext().getAuthentication();
        if (clientAuthentication instanceof OAuth2ClientAuthenticationToken) {
            token = (OAuth2ClientAuthenticationToken)clientAuthentication;
        }
        if (ObjectUtils.isNotEmpty(token) && token.isAuthenticated()) {
            JwtClaimsSet.Builder jwtClaimSetBuilder;
            HashMap<String, Object> attributes;
            Authentication authentication;
            if (OAuth2TokenType.ACCESS_TOKEN.equals((Object)context.getTokenType()) && ObjectUtils.isNotEmpty((Object)(authentication = context.getPrincipal()))) {
                attributes = new HashMap<String, Object>();
                this.appendAll(attributes, authentication, context.getAuthorizedScopes());
                jwtClaimSetBuilder = context.getClaims();
                jwtClaimSetBuilder.claims(claims -> claims.putAll(attributes));
            }
            if ("id_token".equals(context.getTokenType().getValue()) && ObjectUtils.isNotEmpty((Object)(authentication = context.getPrincipal()))) {
                attributes = new HashMap();
                this.appendCommons(attributes, authentication, context.getAuthorizedScopes());
                jwtClaimSetBuilder = context.getClaims();
                jwtClaimSetBuilder.claims(claims -> claims.putAll(attributes));
            }
        }
    }
}

