/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.oauth2.authentication.consumer;

import cn.herodotus.stirrup.oauth2.authentication.provider.OidcClientRegistrationToRegisteredClientConverter;
import cn.herodotus.stirrup.oauth2.authentication.provider.RegisteredClientToOidcClientRegistrationConverter;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.oauth2.server.authorization.oidc.authentication.OidcClientConfigurationAuthenticationProvider;
import org.springframework.security.oauth2.server.authorization.oidc.authentication.OidcClientRegistrationAuthenticationProvider;

public class OidcClientRegistrationAuthenticationProviderConsumer
implements Consumer<List<AuthenticationProvider>> {
    private static final List<String> clientMetadata = List.of("product_id");

    @Override
    public void accept(List<AuthenticationProvider> authenticationProviders) {
        OidcClientRegistrationToRegisteredClientConverter toRegisteredClientConverter = new OidcClientRegistrationToRegisteredClientConverter(clientMetadata);
        RegisteredClientToOidcClientRegistrationConverter toOidcClientRegistrationConverter = new RegisteredClientToOidcClientRegistrationConverter(clientMetadata);
        authenticationProviders.forEach(authenticationProvider -> {
            OidcClientRegistrationAuthenticationProvider provider;
            if (authenticationProvider instanceof OidcClientRegistrationAuthenticationProvider) {
                provider = (OidcClientRegistrationAuthenticationProvider)authenticationProvider;
                provider.setRegisteredClientConverter(toRegisteredClientConverter);
                provider.setClientRegistrationConverter(toOidcClientRegistrationConverter);
            }
            if (authenticationProvider instanceof OidcClientConfigurationAuthenticationProvider) {
                provider = (OidcClientConfigurationAuthenticationProvider)authenticationProvider;
                provider.setClientRegistrationConverter(toOidcClientRegistrationConverter);
            }
        });
    }
}

