/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.message.websocket.servlet.sender;

import cn.herodotus.stirrup.core.event.StreamMessageSendingEvent;
import cn.herodotus.stirrup.core.event.domain.StreamMessage;
import cn.herodotus.stirrup.core.foundation.context.ServiceContextHolder;
import cn.herodotus.stirrup.message.websocket.servlet.domain.StompWebSocketMessage;
import cn.herodotus.stirrup.message.websocket.servlet.sender.SingleInstanceMessageSender;
import cn.herodotus.stirrup.message.websocket.servlet.sender.WebSocketMessagingTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;

public class MultipleInstanceMessageSender
extends SingleInstanceMessageSender {
    private static final Logger log = LoggerFactory.getLogger(MultipleInstanceMessageSender.class);

    public MultipleInstanceMessageSender(WebSocketMessagingTemplate webSocketMessagingTemplate) {
        super(webSocketMessagingTemplate);
    }

    @Override
    public void toUser(String userId, String destination, Object payload) {
        this.syncToUserMessage(userId, destination, payload);
        super.toUser(userId, destination, payload);
    }

    @Override
    public void toAll(String destination, Object payload) {
        this.syncToAllMessage(destination, payload);
        super.toAll(destination, payload);
    }

    private void syncMessageToOtherInstants(StompWebSocketMessage stompWebSocketMessage) {
        StreamMessage streamMessage = new StreamMessage();
        streamMessage.setBindingName("webSocketMultipleInstanceSyncOutput");
        streamMessage.setPayload((Object)stompWebSocketMessage);
        log.debug("[Herodotus] |- Sync message to other WebSocket instance.");
        ServiceContextHolder.getInstance().publishEvent((ApplicationEvent)new StreamMessageSendingEvent(streamMessage));
    }

    private void syncToUserMessage(String user, String destination, Object payload) {
        StompWebSocketMessage stompWebSocketMessage = new StompWebSocketMessage();
        stompWebSocketMessage.setUserId(user);
        stompWebSocketMessage.setDestination(destination);
        stompWebSocketMessage.setPayload(payload);
        this.syncMessageToOtherInstants(stompWebSocketMessage);
    }

    private void syncToAllMessage(String destination, Object payload) {
        this.syncToUserMessage("message_to_all", destination, payload);
    }
}

