/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.message.websocket.servlet.interceptor;

import cn.herodotus.stirrup.core.identity.domain.UserPrincipal;
import java.security.Principal;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.server.support.DefaultHandshakeHandler;

public class WebSocketPrincipalHandshakeHandler
extends DefaultHandshakeHandler {
    private static final Logger log = LoggerFactory.getLogger(WebSocketPrincipalHandshakeHandler.class);

    protected Principal determineUser(ServerHttpRequest request, WebSocketHandler wsHandler, Map<String, Object> attributes) {
        Object object = attributes.get("principal");
        if (ObjectUtils.isNotEmpty((Object)object) && object instanceof UserPrincipal) {
            UserPrincipal details = (UserPrincipal)object;
            log.debug("[Herodotus] |- Determine user by request parameter, userId is  [{}].", (Object)details.getId());
            return details;
        }
        Principal principal = request.getPrincipal();
        if (ObjectUtils.isNotEmpty((Object)principal)) {
            log.debug("[Herodotus] |- Determine user from request, value is  [{}].", (Object)principal.getName());
            return principal;
        }
        log.warn("[Herodotus] |- Can not determine user from request.");
        return null;
    }
}

