/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.message.websocket.servlet.definition;

import cn.herodotus.stirrup.cache.redis.utils.RedisBitMapUtils;
import cn.herodotus.stirrup.core.identity.domain.UserPrincipal;
import cn.herodotus.stirrup.message.websocket.servlet.definition.WebSocketMessageSender;
import cn.herodotus.stirrup.message.websocket.servlet.utils.WebSocketUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public abstract class AbstractWebSocketStatusListener<E extends ApplicationEvent>
implements ApplicationListener<E> {
    private static final Logger log = LoggerFactory.getLogger(AbstractWebSocketStatusListener.class);
    private final WebSocketMessageSender webSocketMessageSender;

    public AbstractWebSocketStatusListener(WebSocketMessageSender webSocketMessageSender) {
        this.webSocketMessageSender = webSocketMessageSender;
    }

    private void changeStatus(UserPrincipal principal, boolean isOnline) {
        if (ObjectUtils.isNotEmpty((Object)principal)) {
            RedisBitMapUtils.setBit((String)"data:message:online:user", (String)principal.getName(), (boolean)isOnline);
            String status = isOnline ? "Online" : "Offline";
            log.debug("[Herodotus] |- WebSocket user [{}] is [{}].", (Object)principal, (Object)status);
            int count = WebSocketUtils.getOnlineCount();
            this.webSocketMessageSender.online(count);
        }
    }

    protected void connected(UserPrincipal principal) {
        this.changeStatus(principal, true);
    }

    protected void disconnected(UserPrincipal principal) {
        this.changeStatus(principal, false);
    }
}

