/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.message.websocket.servlet.config;

import cn.herodotus.stirrup.message.core.websocket.WebSocketProperties;
import cn.herodotus.stirrup.message.websocket.servlet.interceptor.WebSocketAuthenticationHandshakeInterceptor;
import cn.herodotus.stirrup.message.websocket.servlet.interceptor.WebSocketChannelInterceptor;
import cn.herodotus.stirrup.message.websocket.servlet.interceptor.WebSocketPrincipalHandshakeHandler;
import cn.herodotus.stirrup.message.websocket.servlet.properties.StompProperties;
import jakarta.annotation.PostConstruct;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.simp.config.ChannelRegistration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.session.Session;
import org.springframework.session.web.socket.config.annotation.AbstractSessionWebSocketMessageBrokerConfigurer;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketTransportRegistration;
import org.springframework.web.socket.server.HandshakeHandler;
import org.springframework.web.socket.server.HandshakeInterceptor;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={WebSocketProperties.class, StompProperties.class})
@EnableScheduling
@EnableWebSocketMessageBroker
public class WebSocketMessageBrokerConfiguration
extends AbstractSessionWebSocketMessageBrokerConfigurer<Session> {
    private static final Logger log = LoggerFactory.getLogger(WebSocketMessageBrokerConfiguration.class);
    private final StompProperties stompProperties;
    private final WebSocketChannelInterceptor webSocketChannelInterceptor;
    private final WebSocketPrincipalHandshakeHandler webSocketPrincipalHandshakeHandler;
    private final WebSocketAuthenticationHandshakeInterceptor webSocketAuthenticationHandshakeInterceptor;

    public WebSocketMessageBrokerConfiguration(StompProperties stompProperties, WebSocketAuthenticationHandshakeInterceptor webSocketAuthenticationHandshakeInterceptor) {
        this.stompProperties = stompProperties;
        this.webSocketChannelInterceptor = new WebSocketChannelInterceptor();
        this.webSocketPrincipalHandshakeHandler = new WebSocketPrincipalHandshakeHandler();
        this.webSocketAuthenticationHandshakeInterceptor = webSocketAuthenticationHandshakeInterceptor;
    }

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- Module [WebSocket Message Broker] Configure.");
    }

    protected void configureStompEndpoints(StompEndpointRegistry registry) {
        registry.addEndpoint(new String[]{this.stompProperties.getEndpoint()}).setAllowedOrigins(new String[]{"*"}).addInterceptors(new HandshakeInterceptor[]{this.webSocketAuthenticationHandshakeInterceptor}).setHandshakeHandler((HandshakeHandler)this.webSocketPrincipalHandshakeHandler).withSockJS();
        registry.addEndpoint(new String[]{this.stompProperties.getEndpoint()}).setAllowedOrigins(new String[]{"*"}).addInterceptors(new HandshakeInterceptor[]{this.webSocketAuthenticationHandshakeInterceptor}).setHandshakeHandler((HandshakeHandler)this.webSocketPrincipalHandshakeHandler);
    }

    public void configureMessageBroker(MessageBrokerRegistry registry) {
        ThreadPoolTaskScheduler taskScheduler = new ThreadPoolTaskScheduler();
        taskScheduler.setPoolSize(1);
        taskScheduler.setThreadNamePrefix("herodotus-websocket-heartbeat-thread-");
        taskScheduler.initialize();
        registry.enableSimpleBroker(new String[]{"/broadcast", "/personal"}).setHeartbeatValue(new long[]{10000L, 10000L}).setTaskScheduler((TaskScheduler)taskScheduler);
        Object[] applicationDestinationPrefixes = this.stompProperties.getApplicationPrefixes();
        if (ArrayUtils.isNotEmpty((Object[])applicationDestinationPrefixes)) {
            registry.setApplicationDestinationPrefixes((String[])applicationDestinationPrefixes);
        }
        if (StringUtils.isNotBlank((CharSequence)this.stompProperties.getUserDestinationPrefix())) {
            registry.setUserDestinationPrefix(this.stompProperties.getUserDestinationPrefix());
        }
    }

    public void configureWebSocketTransport(WebSocketTransportRegistration registration) {
        registration.setMessageSizeLimit(10240).setSendBufferSizeLimit(10240).setSendTimeLimit(10000);
        super.configureWebSocketTransport(registration);
    }

    public void configureClientInboundChannel(ChannelRegistration registration) {
        registration.taskExecutor().corePoolSize(10).maxPoolSize(20).keepAliveSeconds(60);
        registration.interceptors(new ChannelInterceptor[]{this.webSocketChannelInterceptor});
        super.configureClientInboundChannel(registration);
    }

    public void configureClientOutboundChannel(ChannelRegistration registration) {
        registration.taskExecutor().corePoolSize(10).maxPoolSize(20).keepAliveSeconds(60);
    }
}

