/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.message.websocket.servlet.config;

import cn.herodotus.stirrup.core.identity.oauth2.BearerTokenResolver;
import cn.herodotus.stirrup.message.core.websocket.annotation.ConditionalOnMultipleWebSocketInstance;
import cn.herodotus.stirrup.message.core.websocket.annotation.ConditionalOnSingleWebSocketInstance;
import cn.herodotus.stirrup.message.websocket.servlet.config.WebSocketMessageBrokerConfiguration;
import cn.herodotus.stirrup.message.websocket.servlet.definition.WebSocketMessageSender;
import cn.herodotus.stirrup.message.websocket.servlet.domain.StompWebSocketMessage;
import cn.herodotus.stirrup.message.websocket.servlet.interceptor.WebSocketAuthenticationHandshakeInterceptor;
import cn.herodotus.stirrup.message.websocket.servlet.sender.MultipleInstanceMessageSender;
import cn.herodotus.stirrup.message.websocket.servlet.sender.MultipleInstanceMessageSyncConsumer;
import cn.herodotus.stirrup.message.websocket.servlet.sender.SingleInstanceMessageSender;
import cn.herodotus.stirrup.message.websocket.servlet.sender.WebSocketMessageSendingAdapter;
import cn.herodotus.stirrup.message.websocket.servlet.sender.WebSocketMessagingTemplate;
import jakarta.annotation.PostConstruct;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.messaging.simp.user.SimpUserRegistry;

@Configuration(proxyBeanMethods=false)
public class MessageServletWebSocketConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MessageServletWebSocketConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- Module [Message Servlet WebSocket] Configure.");
    }

    @Bean
    public WebSocketAuthenticationHandshakeInterceptor webSocketPrincipalHandshakeHandler(BearerTokenResolver bearerTokenResolver) {
        WebSocketAuthenticationHandshakeInterceptor interceptor = new WebSocketAuthenticationHandshakeInterceptor(bearerTokenResolver);
        log.trace("[Herodotus] |- Bean [WebSocket Authentication Handshake Interceptor] Configure.");
        return interceptor;
    }

    @Bean
    @ConditionalOnMissingBean
    public WebSocketMessagingTemplate webSocketMessagingTemplate(SimpMessagingTemplate simpMessagingTemplate, SimpUserRegistry simpUserRegistry) {
        WebSocketMessagingTemplate template = new WebSocketMessagingTemplate(simpMessagingTemplate, simpUserRegistry);
        log.trace("[Herodotus] |- Bean [WebSocket Messaging Template] Configure.");
        return template;
    }

    @Configuration(proxyBeanMethods=false)
    @Import(value={WebSocketMessageBrokerConfiguration.class})
    @ComponentScan(basePackages={"cn.herodotus.stirrup.message.websocket.servlet.controller", "cn.herodotus.stirrup.message.websocket.servlet.listener"})
    static class WebSocketConfiguration {
        WebSocketConfiguration() {
        }

        @Bean
        public WebSocketMessageSendingAdapter webSocketMessageSendingAdapter(WebSocketMessageSender webSocketMessageSender) {
            WebSocketMessageSendingAdapter adapter = new WebSocketMessageSendingAdapter(webSocketMessageSender);
            log.trace("[Herodotus] |- Bean [WebSocket Message Sending Adapter] Configure.");
            return adapter;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMultipleWebSocketInstance
    static class MultipleInstanceConfiguration {
        MultipleInstanceConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public WebSocketMessageSender multipleInstanceMessageSender(WebSocketMessagingTemplate webSocketMessagingTemplate) {
            MultipleInstanceMessageSender sender = new MultipleInstanceMessageSender(webSocketMessagingTemplate);
            log.debug("[Herodotus] |- Strategy [Multiple Instance Web Socket Message Sender] Configure.");
            return sender;
        }

        @Bean
        public Consumer<StompWebSocketMessage> webSocketConsumer(WebSocketMessagingTemplate webSocketMessagingTemplate) {
            MultipleInstanceMessageSyncConsumer consumer = new MultipleInstanceMessageSyncConsumer(webSocketMessagingTemplate);
            log.trace("[Herodotus] |- Bean [Multiple Instance Message Receiver] Configure.");
            return consumer;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnSingleWebSocketInstance
    static class SingleInstanceConfiguration {
        SingleInstanceConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public WebSocketMessageSender singleInstanceMessageSender(WebSocketMessagingTemplate webSocketMessagingTemplate) {
            SingleInstanceMessageSender sender = new SingleInstanceMessageSender(webSocketMessagingTemplate);
            log.debug("[Herodotus] |- Strategy [Single Instance Web Socket Message Sender] Configure.");
            return sender;
        }
    }
}

