/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Stirrup.
 *
 * Herodotus Stirrup is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Stirrup is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.message.websocket.servlet.sender;

import cn.herodotus.stirrup.core.event.WebSocketMessageSendingEvent;
import cn.herodotus.stirrup.core.event.definition.MessageSendingAdapter;
import cn.herodotus.stirrup.message.websocket.servlet.definition.WebSocketMessageSender;
import cn.herodotus.stirrup.message.websocket.servlet.domain.StompWebSocketMessage;
import org.apache.commons.lang3.StringUtils;

/**
 * <p>Description: WebSocket 消息发送适配器 </p>
 * <p>
 * 用于模块外部，统一门面方式发送消息使用。
 *
 * @author : gengwei.zheng
 * @date : 2024/4/15 0:22
 */
public class WebSocketMessageSendingAdapter implements MessageSendingAdapter<Object, StompWebSocketMessage, WebSocketMessageSendingEvent<Object, StompWebSocketMessage>> {

    private final WebSocketMessageSender webSocketMessageSender;

    public WebSocketMessageSendingAdapter(WebSocketMessageSender webSocketMessageSender) {
        this.webSocketMessageSender = webSocketMessageSender;
    }

    @Override
    public void onApplicationEvent(WebSocketMessageSendingEvent<Object, StompWebSocketMessage> event) {
        StompWebSocketMessage message = event.getData();

        if (StringUtils.isNotBlank(message.getUserId())) {
            webSocketMessageSender.toUser(message.getUserId(), message.getDestination(), message.getPayload());
        } else {
            webSocketMessageSender.toAll(message.getDestination(), message.getPayload());
        }
    }
}
