/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.message.mqtt.messaging;

import cn.herodotus.stirrup.core.event.MqttMessageSendingEvent;
import cn.herodotus.stirrup.core.event.definition.MessageSendingAdapter;
import cn.herodotus.stirrup.core.event.domain.MqttMessage;
import cn.herodotus.stirrup.message.mqtt.messaging.MqttMessagingTemplate;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class MqttMessageSendingAdapter
implements MessageSendingAdapter<String, MqttMessage, MqttMessageSendingEvent> {
    private final MqttMessagingTemplate mqttMessagingTemplate;

    public MqttMessageSendingAdapter(MqttMessagingTemplate mqttMessagingTemplate) {
        this.mqttMessagingTemplate = mqttMessagingTemplate;
    }

    public void onApplicationEvent(MqttMessageSendingEvent event) {
        MqttMessage mqttMessage = (MqttMessage)event.getData();
        if (StringUtils.isNotBlank((CharSequence)mqttMessage.getTopic()) && ObjectUtils.isNotEmpty((Object)mqttMessage.getQos())) {
            if (StringUtils.isNotBlank((CharSequence)mqttMessage.getResponseTopic()) && StringUtils.isNotBlank((CharSequence)mqttMessage.getCorrelationData())) {
                this.mqttMessagingTemplate.publish(mqttMessage.getTopic(), mqttMessage.getResponseTopic(), mqttMessage.getCorrelationData(), mqttMessage.getQos(), mqttMessage.getPayload());
            } else {
                this.mqttMessagingTemplate.publish(mqttMessage.getTopic(), mqttMessage.getQos(), mqttMessage.getPayload());
            }
        } else {
            if (StringUtils.isNotBlank((CharSequence)mqttMessage.getTopic())) {
                this.mqttMessagingTemplate.publish(mqttMessage.getTopic(), mqttMessage.getPayload());
            }
            if (ObjectUtils.isNotEmpty((Object)mqttMessage.getQos())) {
                this.mqttMessagingTemplate.publish(mqttMessage.getQos(), mqttMessage.getPayload());
            }
        }
    }
}

