/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.message.mqtt.config;

import cn.herodotus.stirrup.core.foundation.utils.type.ListUtils;
import cn.herodotus.stirrup.core.foundation.utils.type.NumberUtils;
import cn.herodotus.stirrup.message.mqtt.annotation.ConditionalOnMqttEnabled;
import cn.herodotus.stirrup.message.mqtt.properties.MqttProperties;
import jakarta.annotation.PostConstruct;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.dromara.hutool.core.util.ByteUtil;
import org.eclipse.paho.mqttv5.client.IMqttAsyncClient;
import org.eclipse.paho.mqttv5.client.MqttClientPersistence;
import org.eclipse.paho.mqttv5.client.MqttConnectionOptions;
import org.eclipse.paho.mqttv5.client.persist.MqttDefaultFilePersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.annotation.IntegrationComponentScan;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.integration.core.MessageProducer;
import org.springframework.integration.dsl.MessageChannels;
import org.springframework.integration.mqtt.core.ClientManager;
import org.springframework.integration.mqtt.core.Mqttv5ClientManager;
import org.springframework.integration.mqtt.inbound.Mqttv5PahoMessageDrivenChannelAdapter;
import org.springframework.integration.mqtt.outbound.Mqttv5PahoMessageHandler;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.util.Assert;

@Configuration(proxyBeanMethods=false)
@ConditionalOnMqttEnabled
@EnableConfigurationProperties(value={MqttProperties.class})
@IntegrationComponentScan(basePackages={"cn.herodotus.stirrup.message.mqtt.gateway"})
@ComponentScan(basePackages={"cn.herodotus.stirrup.message.mqtt.messaging"})
public class MessageMqttConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MessageMqttConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- Module [Message Mqtt] Configure.");
    }

    @Bean(name={"mqttDefaultInboundChannel"})
    public MessageChannel mqttDefaultInboundChannel() {
        return (MessageChannel)MessageChannels.publishSubscribe().getObject();
    }

    @Bean(name={"mqttDefaultOutboundChannel"})
    public MessageChannel mqttDefaultOutboundChannel() {
        return (MessageChannel)MessageChannels.direct().getObject();
    }

    @Bean
    public ClientManager<IMqttAsyncClient, MqttConnectionOptions> clientManager(MqttProperties mqttProperties) {
        MqttConnectionOptions options = new MqttConnectionOptions();
        options.setUserName(mqttProperties.getUsername());
        options.setPassword(ByteUtil.toBytes((CharSequence)mqttProperties.getPassword(), (Charset)StandardCharsets.UTF_8));
        options.setCleanStart(mqttProperties.getCleanStart().booleanValue());
        options.setKeepAliveInterval(NumberUtils.longToInt((long)mqttProperties.getKeepAliveInterval().getSeconds()));
        options.setServerURIs(ListUtils.toStringArray(mqttProperties.getServerUrls()));
        options.setAutomaticReconnect(mqttProperties.getAutomaticReconnect().booleanValue());
        options.setAutomaticReconnectDelay(NumberUtils.longToInt((long)mqttProperties.getAutomaticReconnectMinDelay().getSeconds()), NumberUtils.longToInt((long)mqttProperties.getAutomaticReconnectMaxDelay().getSeconds()));
        Mqttv5ClientManager clientManager = new Mqttv5ClientManager(options, mqttProperties.getClientId());
        clientManager.setPersistence((MqttClientPersistence)new MqttDefaultFilePersistence());
        log.trace("[Herodotus] |- Bean [Mqtt Connection Options] Configure.");
        return clientManager;
    }

    @Bean
    public MessageProducer mqttDefaultInbound(ClientManager<IMqttAsyncClient, MqttConnectionOptions> clientManager, @Qualifier(value="mqttDefaultInboundChannel") MessageChannel mqttDefaultInboundChannel, MqttProperties mqttProperties) {
        Assert.notNull(mqttProperties.getDefaultSubscribes(), (String)"'Property Subscribes' cannot be null");
        Mqttv5PahoMessageDrivenChannelAdapter adapter = new Mqttv5PahoMessageDrivenChannelAdapter(clientManager, ListUtils.toStringArray(mqttProperties.getDefaultSubscribes()));
        adapter.setPayloadType(String.class);
        adapter.setManualAcks(false);
        adapter.setOutputChannel(mqttDefaultInboundChannel);
        log.trace("[Herodotus] |- Bean [Mqtt v5 Paho Message Driven Channel Adapter] Configure.");
        return adapter;
    }

    @Bean
    @ServiceActivator(inputChannel="mqttDefaultOutboundChannel")
    public MessageHandler mqttDefaultOutbound(ClientManager<IMqttAsyncClient, MqttConnectionOptions> clientManager, MqttProperties mqttProperties) {
        Mqttv5PahoMessageHandler handler = new Mqttv5PahoMessageHandler(clientManager);
        handler.setDefaultTopic(mqttProperties.getDefaultTopic());
        handler.setDefaultQos(mqttProperties.getDefaultQos().intValue());
        handler.setAsync(true);
        handler.setAsyncEvents(true);
        log.trace("[Herodotus] |- Bean [Mqtt v5 Paho Message Handler] Configure.");
        return handler;
    }
}

