/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.logic.sas.jpa.definition;

import cn.herodotus.stirrup.core.definition.domain.base.Entity;
import cn.herodotus.stirrup.logic.sas.jpa.converter.HerodotusToOAuth2AuthorizationConsentConverter;
import cn.herodotus.stirrup.logic.sas.jpa.converter.OAuth2ToHerodotusAuthorizationConsentConverter;
import cn.herodotus.stirrup.logic.sas.jpa.entity.HerodotusAuthorizationConsent;
import cn.herodotus.stirrup.logic.sas.jpa.service.HerodotusAuthorizationConsentService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationConsent;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationConsentService;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;

public class JpaOAuth2AuthorizationConsentService
implements OAuth2AuthorizationConsentService {
    private final HerodotusAuthorizationConsentService herodotusAuthorizationConsentService;
    private final Converter<HerodotusAuthorizationConsent, OAuth2AuthorizationConsent> herodotusToOAuth2Converter;
    private final Converter<OAuth2AuthorizationConsent, HerodotusAuthorizationConsent> oauth2ToherodotusConverter;

    public JpaOAuth2AuthorizationConsentService(HerodotusAuthorizationConsentService herodotusAuthorizationConsentService, RegisteredClientRepository registeredClientRepository) {
        this.herodotusAuthorizationConsentService = herodotusAuthorizationConsentService;
        this.herodotusToOAuth2Converter = new HerodotusToOAuth2AuthorizationConsentConverter(registeredClientRepository);
        this.oauth2ToherodotusConverter = new OAuth2ToHerodotusAuthorizationConsentConverter();
    }

    public void save(OAuth2AuthorizationConsent authorizationConsent) {
        this.herodotusAuthorizationConsentService.save((Entity)this.toEntity(authorizationConsent));
    }

    public void remove(OAuth2AuthorizationConsent authorizationConsent) {
        this.herodotusAuthorizationConsentService.deleteByRegisteredClientIdAndPrincipalName(authorizationConsent.getRegisteredClientId(), authorizationConsent.getPrincipalName());
    }

    public OAuth2AuthorizationConsent findById(String registeredClientId, String principalName) {
        return this.herodotusAuthorizationConsentService.findByRegisteredClientIdAndPrincipalName(registeredClientId, principalName).map(this::toObject).orElse(null);
    }

    private OAuth2AuthorizationConsent toObject(HerodotusAuthorizationConsent authorizationConsent) {
        return (OAuth2AuthorizationConsent)this.herodotusToOAuth2Converter.convert((Object)authorizationConsent);
    }

    private HerodotusAuthorizationConsent toEntity(OAuth2AuthorizationConsent authorizationConsent) {
        return (HerodotusAuthorizationConsent)((Object)this.oauth2ToherodotusConverter.convert((Object)authorizationConsent));
    }
}

