/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.logic.sas.jpa.converter;

import cn.herodotus.stirrup.logic.sas.jpa.entity.HerodotusAuthorizationConsent;
import java.util.HashSet;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationConsent;
import org.springframework.util.StringUtils;

public class OAuth2ToHerodotusAuthorizationConsentConverter
implements Converter<OAuth2AuthorizationConsent, HerodotusAuthorizationConsent> {
    public HerodotusAuthorizationConsent convert(OAuth2AuthorizationConsent authorizationConsent) {
        HerodotusAuthorizationConsent entity = new HerodotusAuthorizationConsent();
        entity.setRegisteredClientId(authorizationConsent.getRegisteredClientId());
        entity.setPrincipalName(authorizationConsent.getPrincipalName());
        HashSet<String> authorities = new HashSet<String>();
        for (GrantedAuthority authority : authorizationConsent.getAuthorities()) {
            authorities.add(authority.getAuthority());
        }
        entity.setAuthorities(StringUtils.collectionToCommaDelimitedString(authorities));
        return entity;
    }
}

