/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.logic.sas.jpa.config;

import cn.herodotus.stirrup.logic.sas.jpa.definition.JpaOAuth2AuthorizationConsentService;
import cn.herodotus.stirrup.logic.sas.jpa.definition.JpaOAuth2AuthorizationService;
import cn.herodotus.stirrup.logic.sas.jpa.definition.JpaRegisteredClientRepository;
import cn.herodotus.stirrup.logic.sas.jpa.listener.DeleteRegisteredClientListener;
import cn.herodotus.stirrup.logic.sas.jpa.service.HerodotusAuthorizationConsentService;
import cn.herodotus.stirrup.logic.sas.jpa.service.HerodotusAuthorizationService;
import cn.herodotus.stirrup.logic.sas.jpa.service.HerodotusRegisteredClientService;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationConsentService;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;

@Configuration(proxyBeanMethods=false)
@EntityScan(basePackages={"cn.herodotus.stirrup.logic.sas.jpa.entity"})
@EnableJpaRepositories(basePackages={"cn.herodotus.stirrup.logic.sas.jpa.repository"})
@ComponentScan(basePackages={"cn.herodotus.stirrup.logic.sas.jpa.service"})
public class LogicSasJpaConfiguration {
    private static final Logger log = LoggerFactory.getLogger(LogicSasJpaConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- Module [Logic Sas JPA] Configure.");
    }

    @Bean
    @ConditionalOnMissingBean
    public RegisteredClientRepository registeredClientRepository(HerodotusRegisteredClientService herodotusRegisteredClientService, PasswordEncoder passwordEncoder) {
        JpaRegisteredClientRepository jpaRegisteredClientRepository = new JpaRegisteredClientRepository(herodotusRegisteredClientService, passwordEncoder);
        log.debug("[Herodotus] |- Bean [Jpa Registered Client Repository] Configure.");
        return jpaRegisteredClientRepository;
    }

    @Bean
    @ConditionalOnMissingBean
    public OAuth2AuthorizationService authorizationService(HerodotusAuthorizationService herodotusAuthorizationService, RegisteredClientRepository registeredClientRepository) {
        JpaOAuth2AuthorizationService jpaOAuth2AuthorizationService = new JpaOAuth2AuthorizationService(herodotusAuthorizationService, registeredClientRepository);
        log.debug("[Herodotus] |- Bean [Jpa OAuth2 Authorization Service] Configure.");
        return jpaOAuth2AuthorizationService;
    }

    @Bean
    @ConditionalOnMissingBean
    public OAuth2AuthorizationConsentService authorizationConsentService(HerodotusAuthorizationConsentService herodotusAuthorizationConsentService, RegisteredClientRepository registeredClientRepository) {
        JpaOAuth2AuthorizationConsentService jpaOAuth2AuthorizationConsentService = new JpaOAuth2AuthorizationConsentService(herodotusAuthorizationConsentService, registeredClientRepository);
        log.debug("[Herodotus] |- Bean [Jpa OAuth2 Authorization Consent Service] Configure.");
        return jpaOAuth2AuthorizationConsentService;
    }

    @Bean
    @ConditionalOnMissingBean
    public DeleteRegisteredClientListener deleteRegisteredClientListener(HerodotusAuthorizationService herodotusAuthorizationService) {
        DeleteRegisteredClientListener listener = new DeleteRegisteredClientListener(herodotusAuthorizationService);
        log.debug("[Herodotus] |- Bean [Delete Registered Client Listener] Configure.");
        return listener;
    }
}

