/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Stirrup.
 *
 * Herodotus Stirrup is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Stirrup is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.logic.client.jpa.storage;

import cn.herodotus.stirrup.logic.client.jpa.converter.HerodotusToOAuth2ClientRegistrationConverter;
import cn.herodotus.stirrup.logic.client.jpa.converter.OAuth2ToHerodotusClientRegistrationConverter;
import cn.herodotus.stirrup.logic.client.jpa.entity.HerodotusClientRegistration;
import cn.herodotus.stirrup.logic.client.jpa.service.HerodotusClientRegistrationService;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;

/**
 * <p>Description: 基于 JPA 扩展的 ClientRegistrationRepository</p>
 *
 * @author : gengwei.zheng
 * @date : 2023/5/6 23:29
 */
public class JpaClientRegistrationRepository implements ClientRegistrationRepository {

    private static final Logger log = LoggerFactory.getLogger(JpaClientRegistrationRepository.class);

    private final HerodotusClientRegistrationService herodotusClientRegistrationService;
    private final Converter<ClientRegistration, HerodotusClientRegistration> oauth2ToHerodotusClientRegistrationConverter;
    private final Converter<HerodotusClientRegistration, ClientRegistration> herodotusToClientRegistrationConverter;

    public JpaClientRegistrationRepository(HerodotusClientRegistrationService herodotusClientRegistrationService) {
        this.herodotusClientRegistrationService = herodotusClientRegistrationService;
        this.oauth2ToHerodotusClientRegistrationConverter = new OAuth2ToHerodotusClientRegistrationConverter();
        this.herodotusToClientRegistrationConverter = new HerodotusToOAuth2ClientRegistrationConverter();
    }

    @Override
    public ClientRegistration findByRegistrationId(String registrationId) {
        HerodotusClientRegistration herodotusClientRegistration = herodotusClientRegistrationService.findByRegistrationId(registrationId);
        if (ObjectUtils.isNotEmpty(herodotusClientRegistration)) {
            return herodotusToClientRegistrationConverter.convert(herodotusClientRegistration);
        } else {
            return null;
        }
    }

    public boolean saveOrUpdate(ClientRegistration clientRegistration) {
        HerodotusClientRegistration result = herodotusClientRegistrationService.saveAndFlush(oauth2ToHerodotusClientRegistrationConverter.convert(clientRegistration));
        return ObjectUtils.isNotEmpty(result);
    }
}
