/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Stirrup.
 *
 * Herodotus Stirrup is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Stirrup is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.logic.client.jpa.service;

import cn.herodotus.stirrup.data.crud.repository.BaseJpaRepository;
import cn.herodotus.stirrup.data.crud.service.AbstractJpaService;
import cn.herodotus.stirrup.logic.client.jpa.converter.OAuth2ToHerodotusClientRegistrationConverter;
import cn.herodotus.stirrup.logic.client.jpa.entity.HerodotusClientRegistration;
import cn.herodotus.stirrup.logic.client.jpa.repository.HerodotusClientRegistrationRepository;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>Description: OAuth2ClientRegistrationService </p>
 *
 * @author : gengwei.zheng
 * @date : 2023/5/6 23:27
 */
@Service
public class HerodotusClientRegistrationService extends AbstractJpaService<HerodotusClientRegistration, String> {

    private static final Logger log = LoggerFactory.getLogger(HerodotusClientRegistrationService.class);

    private final HerodotusClientRegistrationRepository clientRegistrationRepository;
    private final Converter<ClientRegistration, HerodotusClientRegistration> converter;

    public HerodotusClientRegistrationService(HerodotusClientRegistrationRepository clientRegistrationRepository) {
        this.clientRegistrationRepository = clientRegistrationRepository;
        this.converter = new OAuth2ToHerodotusClientRegistrationConverter();
    }

    @Override
    public BaseJpaRepository<HerodotusClientRegistration, String> getRepository() {
        return clientRegistrationRepository;
    }

    public HerodotusClientRegistration findByRegistrationId(String registrationId) {
        HerodotusClientRegistration herodotusClientRegistration = clientRegistrationRepository.findByRegistrationId(registrationId);
        log.debug("[Herodotus] |- HerodotusClientRegistration Service findByRegistrationId.");
        return herodotusClientRegistration;
    }

    private List<HerodotusClientRegistration> toEntities(List<ClientRegistration> clientRegistrations) {
        return clientRegistrations.stream().map(converter::convert).collect(Collectors.toList());
    }

    public boolean batchSaveOrUpdate(List<ClientRegistration> clientRegistrations) {
        if (CollectionUtils.isNotEmpty(clientRegistrations)) {
            List<HerodotusClientRegistration> result = super.saveAllAndFlush(toEntities(clientRegistrations));
            return CollectionUtils.isNotEmpty(result);
        }

        return false;
    }
}
