/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Stirrup.
 *
 * Herodotus Stirrup is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Stirrup is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.logic.client.jpa.service;

import cn.herodotus.stirrup.data.crud.repository.BaseJpaRepository;
import cn.herodotus.stirrup.data.crud.service.AbstractJpaService;
import cn.herodotus.stirrup.logic.client.jpa.entity.HerodotusAuthorizedClient;
import cn.herodotus.stirrup.logic.client.jpa.generator.HerodotusAuthorizedClientId;
import cn.herodotus.stirrup.logic.client.jpa.repository.HerodotusAuthorizedClientRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.Optional;

/**
 * <p>Description: OAuth2AuthorizedClientService </p>
 *
 * @author : gengwei.zheng
 * @date : 2023/5/6 23:23
 */
@Service
public class HerodotusAuthorizedClientService extends AbstractJpaService<HerodotusAuthorizedClient, HerodotusAuthorizedClientId> {

    private static final Logger log = LoggerFactory.getLogger(HerodotusAuthorizedClientService.class);

    private final HerodotusAuthorizedClientRepository authorizedClientRepository;

    public HerodotusAuthorizedClientService(HerodotusAuthorizedClientRepository authorizedClientRepository) {
        this.authorizedClientRepository = authorizedClientRepository;
    }

    @Override
    public BaseJpaRepository<HerodotusAuthorizedClient, HerodotusAuthorizedClientId> getRepository() {
        return authorizedClientRepository;
    }

    public Optional<HerodotusAuthorizedClient> findByRegisteredClientIdAndPrincipalName(String clientRegistrationId, String principalName) {
        Optional<HerodotusAuthorizedClient> result = this.authorizedClientRepository.findByClientRegistrationIdAndPrincipalName(clientRegistrationId, principalName);
        log.debug("[Herodotus] |- HerodotusAuthorizedClient Service findByRegisteredClientIdAndPrincipalName.");
        return result;
    }

    public void deleteByClientRegistrationIdAndPrincipalName(String clientRegistrationId, String principalName) {
        authorizedClientRepository.deleteByClientRegistrationIdAndPrincipalName(clientRegistrationId, principalName);
    }
}
