/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Stirrup.
 *
 * Herodotus Stirrup is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Stirrup is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.logic.client.jpa.processor;

import cn.herodotus.stirrup.logic.client.jpa.service.HerodotusClientRegistrationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientProperties;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientPropertiesMapper;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.security.oauth2.client.registration.ClientRegistration;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>Description: 客户端注册信息初始化处理器 </p>
 *
 * @author : gengwei.zheng
 * @date : 2023/5/20 22:00
 */
public class ClientRegistrationInitializationProcessor implements ApplicationListener<ApplicationReadyEvent> {

    private static final Logger log = LoggerFactory.getLogger(HerodotusClientRegistrationService.class);

    private final OAuth2ClientProperties clientProperties;
    private final HerodotusClientRegistrationService clientRegistrationService;

    public ClientRegistrationInitializationProcessor(OAuth2ClientProperties clientProperties, HerodotusClientRegistrationService clientRegistrationService) {
        this.clientProperties = clientProperties;
        this.clientRegistrationService = clientRegistrationService;
    }

    @Override
    public void onApplicationEvent(ApplicationReadyEvent event) {

        List<ClientRegistration> registrations = new ArrayList<>(new OAuth2ClientPropertiesMapper(clientProperties).asClientRegistrations().values());
        boolean success = clientRegistrationService.batchSaveOrUpdate(registrations);
        if (success) {
            log.info("[Herodotus] |- Successfully initialized client registration information");
        } else {
            log.error("[Herodotus] |- Client registration information initialization failed");
        }
    }
}
