/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Stirrup.
 *
 * Herodotus Stirrup is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Stirrup is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.logic.client.jpa.entity;

import cn.herodotus.stirrup.core.definition.domain.base.AbstractEntity;
import cn.herodotus.stirrup.logic.client.jpa.constants.LogicClientJpaConstants;
import cn.herodotus.stirrup.logic.client.jpa.generator.HerodotusClientRegistrationUuid;
import com.google.common.base.MoreObjects;
import jakarta.persistence.*;
import org.hibernate.annotations.CacheConcurrencyStrategy;

/**
 * <p>Description: OAuth2ClientRegistration </p>
 *
 * 对应的是 security.oauth2.client.registration 配置中的对象结构。可以将配置文件中的配置存储到数据库中方便使用。
 *
 * @author : gengwei.zheng
 * @date : 2023/5/6 15:39
 */
@Entity
@Table(name = "oauth2_client_registration", indexes = {
        @Index(name = "oauth2_client_registration_id_idx", columnList = "registration_id")}
)
@Cacheable
@org.hibernate.annotations.Cache(usage = CacheConcurrencyStrategy.READ_WRITE, region = LogicClientJpaConstants.REGION_OAUTH2_CLIENT_REGISTRATION)
public class HerodotusClientRegistration extends AbstractEntity {

    @Id
    @HerodotusClientRegistrationUuid
    @Column(name = "registration_id", nullable = false, length = 100)
    private String registrationId;

    @Column(name = "client_id", nullable = false, length = 100)
    private String clientId;

    @Column(name = "client_secret", length = 200)
    private String clientSecret;

    @Column(name = "client_authentication_method", nullable = false, length = 100)
    private String clientAuthenticationMethod;

    @Column(name = "authorization_grant_type", nullable = false, length = 200)
    private String authorizationGrantType;

    @Column(name = "redirect_uri", length = 1000)
    private String redirectUri;

    @Column(name = "scopes", nullable = false, length = 1000)
    private String scopes;

    @Column(name = "client_name", length = 200)
    private String clientName;

    @Column(name = "authorization_uri", length = 1000)
    private String authorizationUri;

    @Column(name = "token_uri", nullable = false, length = 1000)
    private String tokenUri;

    @Column(name = "jwk_set_uri", length = 1000)
    private String jwkSetUri;

    @Column(name = "issuer_uri", length = 1000)
    private String issuerUri;

    @Column(name = "user_info_uri", length = 1000)
    private String userInfoUri;

    @Column(name = "user_info_authentication_method", length = 100)
    private String userInfoAuthenticationMethod;

    @Column(name = "user_name_attribute_name", length = 100)
    private String usernameAttributeName;

    @Column(name = "configuration_metadata", columnDefinition = "TEXT")
    private String configurationMetadata;

    public String getRegistrationId() {
        return registrationId;
    }

    public void setRegistrationId(String registrationId) {
        this.registrationId = registrationId;
    }

    public String getClientId() {
        return clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getClientAuthenticationMethod() {
        return clientAuthenticationMethod;
    }

    public void setClientAuthenticationMethod(String clientAuthenticationMethod) {
        this.clientAuthenticationMethod = clientAuthenticationMethod;
    }

    public String getAuthorizationGrantType() {
        return authorizationGrantType;
    }

    public void setAuthorizationGrantType(String authorizationGrantType) {
        this.authorizationGrantType = authorizationGrantType;
    }

    public String getClientName() {
        return clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public String getRedirectUri() {
        return redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public String getScopes() {
        return scopes;
    }

    public void setScopes(String scopes) {
        this.scopes = scopes;
    }

    public String getAuthorizationUri() {
        return authorizationUri;
    }

    public void setAuthorizationUri(String authorizationUri) {
        this.authorizationUri = authorizationUri;
    }

    public String getTokenUri() {
        return tokenUri;
    }

    public void setTokenUri(String tokenUri) {
        this.tokenUri = tokenUri;
    }

    public String getJwkSetUri() {
        return jwkSetUri;
    }

    public void setJwkSetUri(String jwkSetUri) {
        this.jwkSetUri = jwkSetUri;
    }

    public String getIssuerUri() {
        return issuerUri;
    }

    public void setIssuerUri(String issuerUri) {
        this.issuerUri = issuerUri;
    }

    public String getUserInfoUri() {
        return userInfoUri;
    }

    public void setUserInfoUri(String userInfoUri) {
        this.userInfoUri = userInfoUri;
    }

    public String getUserInfoAuthenticationMethod() {
        return userInfoAuthenticationMethod;
    }

    public void setUserInfoAuthenticationMethod(String userInfoAuthenticationMethod) {
        this.userInfoAuthenticationMethod = userInfoAuthenticationMethod;
    }

    public String getUsernameAttributeName() {
        return usernameAttributeName;
    }

    public void setUsernameAttributeName(String usernameAttributeName) {
        this.usernameAttributeName = usernameAttributeName;
    }

    public String getConfigurationMetadata() {
        return configurationMetadata;
    }

    public void setConfigurationMetadata(String configurationMetadata) {
        this.configurationMetadata = configurationMetadata;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("registrationId", registrationId)
                .add("clientId", clientId)
                .add("clientSecret", clientSecret)
                .add("clientAuthenticationMethod", clientAuthenticationMethod)
                .add("authorizationGrantType", authorizationGrantType)
                .add("clientName", clientName)
                .add("redirectUri", redirectUri)
                .add("scopes", scopes)
                .add("authorizationUri", authorizationUri)
                .add("tokenUri", tokenUri)
                .add("jwkSetUri", jwkSetUri)
                .add("issuerUri", issuerUri)
                .add("userInfoUri", userInfoUri)
                .add("userInfoAuthenticationMethod", userInfoAuthenticationMethod)
                .add("usernameAttributeName", usernameAttributeName)
                .add("configurationMetadata", configurationMetadata)
                .toString();
    }
}
