/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Stirrup.
 *
 * Herodotus Stirrup is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Stirrup is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.logic.client.jpa.entity;

import cn.herodotus.stirrup.core.definition.domain.base.AbstractEntity;
import cn.herodotus.stirrup.logic.client.jpa.constants.LogicClientJpaConstants;
import cn.herodotus.stirrup.logic.client.jpa.generator.HerodotusAuthorizedClientId;
import com.google.common.base.MoreObjects;
import jakarta.persistence.*;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.CreationTimestamp;

import java.time.LocalDateTime;

/**
 * <p>Description: OAuth2 Authorized Client 实体 </p>
 *
 * 客户端认证数据存储。对应的是 spring-security.oauth2-client 模块中，oauth2-client-schema.sql 中的结构
 *
 * @author : gengwei.zheng
 * @date : 2023/5/6 15:38
 */
@Entity
@Table(name = "oauth2_authorized_client", indexes = {
        @Index(name = "oauth2_authorized_client_crid_idx", columnList = "client_registration_id"),
        @Index(name = "oauth2_authorized_client_pn_idx", columnList = "principal_name")})
@IdClass(HerodotusAuthorizedClientId.class)
@Cacheable
@org.hibernate.annotations.Cache(usage = CacheConcurrencyStrategy.READ_WRITE, region = LogicClientJpaConstants.REGION_OAUTH2_AUTHORIZED_CLIENT)
public class HerodotusAuthorizedClient extends AbstractEntity {

    @Id
    @Column(name = "client_registration_id", nullable = false, length = 100)
    private String clientRegistrationId;

    @Id
    @Column(name = "principal_name", nullable = false, length = 200)
    private String principalName;

    @Column(name = "access_token_type", nullable = false, length = 100)
    private String accessTokenType;

    @Column(name = "access_token_value", nullable = false, columnDefinition = "TEXT")
    private String accessTokenValue;

    @Column(name = "access_token_issued_at", nullable = false)
    private LocalDateTime accessTokenIssuedAt;

    @Column(name = "access_token_expires_at", nullable = false)
    private LocalDateTime accessTokenExpiresAt;

    @Column(name = "access_token_scopes", length = 1000)
    private String accessTokenScopes;

    @Column(name = "refresh_token_value", columnDefinition = "TEXT")
    private String refreshTokenValue;

    @Column(name = "refresh_token_issued_at")
    private LocalDateTime refreshTokenIssuedAt;

    @CreationTimestamp
    @Column(name = "created_at")
    private LocalDateTime createdAt;

    public String getClientRegistrationId() {
        return clientRegistrationId;
    }

    public void setClientRegistrationId(String clientRegistrationId) {
        this.clientRegistrationId = clientRegistrationId;
    }

    public String getPrincipalName() {
        return principalName;
    }

    public void setPrincipalName(String principalName) {
        this.principalName = principalName;
    }

    public String getAccessTokenType() {
        return accessTokenType;
    }

    public void setAccessTokenType(String accessTokenType) {
        this.accessTokenType = accessTokenType;
    }

    public String getAccessTokenValue() {
        return accessTokenValue;
    }

    public void setAccessTokenValue(String accessTokenValue) {
        this.accessTokenValue = accessTokenValue;
    }

    public LocalDateTime getAccessTokenIssuedAt() {
        return accessTokenIssuedAt;
    }

    public void setAccessTokenIssuedAt(LocalDateTime accessTokenIssuedAt) {
        this.accessTokenIssuedAt = accessTokenIssuedAt;
    }

    public LocalDateTime getAccessTokenExpiresAt() {
        return accessTokenExpiresAt;
    }

    public void setAccessTokenExpiresAt(LocalDateTime accessTokenExpiresAt) {
        this.accessTokenExpiresAt = accessTokenExpiresAt;
    }

    public String getAccessTokenScopes() {
        return accessTokenScopes;
    }

    public void setAccessTokenScopes(String accessTokenScopes) {
        this.accessTokenScopes = accessTokenScopes;
    }

    public String getRefreshTokenValue() {
        return refreshTokenValue;
    }

    public void setRefreshTokenValue(String refreshTokenValue) {
        this.refreshTokenValue = refreshTokenValue;
    }

    public LocalDateTime getRefreshTokenIssuedAt() {
        return refreshTokenIssuedAt;
    }

    public void setRefreshTokenIssuedAt(LocalDateTime refreshTokenIssuedAt) {
        this.refreshTokenIssuedAt = refreshTokenIssuedAt;
    }

    public LocalDateTime getCreatedAt() {
        return createdAt;
    }

    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("clientRegistrationId", clientRegistrationId)
                .add("principalName", principalName)
                .add("accessTokenType", accessTokenType)
                .add("accessTokenValue", accessTokenValue)
                .add("accessTokenIssuedAt", accessTokenIssuedAt)
                .add("accessTokenExpiresAt", accessTokenExpiresAt)
                .add("accessTokenScopes", accessTokenScopes)
                .add("refreshTokenValue", refreshTokenValue)
                .add("refreshTokenIssuedAt", refreshTokenIssuedAt)
                .add("createdAt", createdAt)
                .toString();
    }
}
