/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Stirrup.
 *
 * Herodotus Stirrup is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Stirrup is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.logic.client.jpa.converter;

import cn.herodotus.stirrup.core.foundation.json.jackson2.utils.Jackson2Utils;
import cn.herodotus.stirrup.logic.client.jpa.entity.HerodotusClientRegistration;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.util.StringUtils;

/**
 * <p>Description: OAuth2ClientRegistration 转 HerodotusClientRegistration 转换器</p>
 *
 * @author : gengwei.zheng
 * @date : 2023/5/22 18:25
 */
public class OAuth2ToHerodotusClientRegistrationConverter implements Converter<ClientRegistration, HerodotusClientRegistration> {

    @Override
    public HerodotusClientRegistration convert(ClientRegistration clientRegistration) {

        HerodotusClientRegistration oauth2ClientRegistration = new HerodotusClientRegistration();
        oauth2ClientRegistration.setRegistrationId(clientRegistration.getRegistrationId());
        oauth2ClientRegistration.setClientId(clientRegistration.getClientId());
        oauth2ClientRegistration.setClientSecret(clientRegistration.getClientSecret());
        oauth2ClientRegistration.setClientAuthenticationMethod(clientRegistration.getClientAuthenticationMethod().getValue());
        oauth2ClientRegistration.setAuthorizationGrantType(clientRegistration.getAuthorizationGrantType().getValue());
        oauth2ClientRegistration.setClientName(clientRegistration.getClientName());
        oauth2ClientRegistration.setRedirectUri(clientRegistration.getRedirectUri());
        oauth2ClientRegistration.setScopes(StringUtils.collectionToCommaDelimitedString(clientRegistration.getScopes()));
        ClientRegistration.ProviderDetails providerDetails = clientRegistration.getProviderDetails();
        if (ObjectUtils.isNotEmpty(providerDetails)) {
            oauth2ClientRegistration.setAuthorizationUri(providerDetails.getAuthorizationUri());
            oauth2ClientRegistration.setTokenUri(providerDetails.getTokenUri());
            oauth2ClientRegistration.setJwkSetUri(providerDetails.getJwkSetUri());
            oauth2ClientRegistration.setIssuerUri(providerDetails.getIssuerUri());

            ClientRegistration.ProviderDetails.UserInfoEndpoint userInfoEndpoint = providerDetails.getUserInfoEndpoint();
            if (ObjectUtils.isNotEmpty(userInfoEndpoint)) {
                oauth2ClientRegistration.setUserInfoUri(userInfoEndpoint.getUri());
                oauth2ClientRegistration.setUserInfoAuthenticationMethod(userInfoEndpoint.getAuthenticationMethod().getValue());
                oauth2ClientRegistration.setUsernameAttributeName(userInfoEndpoint.getUserNameAttributeName());
            }
            oauth2ClientRegistration.setConfigurationMetadata(Jackson2Utils.toJson(providerDetails.getConfigurationMetadata()));
        }
        return oauth2ClientRegistration;
    }
}
