/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Stirrup.
 *
 * Herodotus Stirrup is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Stirrup is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.logic.client.jpa.converter;

import cn.herodotus.stirrup.core.foundation.json.jackson2.utils.Jackson2Utils;
import cn.herodotus.stirrup.logic.client.jpa.entity.HerodotusClientRegistration;
import cn.herodotus.stirrup.oauth2.core.utils.OAuth2AuthorizationUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.util.StringUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>Description: HerodotusClientRegistration 转 OAuth2ClientRegistration 转换器</p>
 *
 * @author : gengwei.zheng
 * @date : 2023/5/22 18:25
 */
public class HerodotusToOAuth2ClientRegistrationConverter implements Converter<HerodotusClientRegistration, ClientRegistration> {
    @Override
    public ClientRegistration convert(HerodotusClientRegistration clientRegistration) {
        ClientAuthenticationMethod clientAuthenticationMethod = clientRegistration.getClientAuthenticationMethod() != null ? OAuth2AuthorizationUtils.resolveClientAuthenticationMethod(clientRegistration.getClientAuthenticationMethod()) : null;
        Map<String, Object> configurationMetadata = clientRegistration.getConfigurationMetadata() != null ? Jackson2Utils.toMap(clientRegistration.getConfigurationMetadata()) : new HashMap<>();

        return ClientRegistration
                .withRegistrationId(clientRegistration.getRegistrationId())
                .clientId(clientRegistration.getClientId())
                .clientSecret(clientRegistration.getClientSecret())
                .clientAuthenticationMethod(clientAuthenticationMethod)
                .authorizationGrantType(OAuth2AuthorizationUtils.resolveAuthorizationGrantType(clientRegistration.getAuthorizationGrantType()))
                .clientName(clientRegistration.getClientName())
                .redirectUri(clientRegistration.getRedirectUri())
                .scope(StringUtils.commaDelimitedListToSet(clientRegistration.getScopes()))
                .authorizationUri(clientRegistration.getAuthorizationUri())
                .tokenUri(clientRegistration.getTokenUri())
                .jwkSetUri(clientRegistration.getJwkSetUri())
                .issuerUri(clientRegistration.getIssuerUri())
                .userInfoUri(clientRegistration.getUserInfoUri())
                .userInfoAuthenticationMethod(OAuth2AuthorizationUtils.resolveAuthenticationMethod(clientRegistration.getUserInfoAuthenticationMethod()))
                .userNameAttributeName(clientRegistration.getUsernameAttributeName())
                .providerConfigurationMetadata(configurationMetadata)
                .build();
    }
}
