/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Stirrup.
 *
 * Herodotus Stirrup is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Stirrup is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.logic.client.jpa.constants;

import cn.herodotus.stirrup.core.definition.constants.BaseConstants;

/**
 * <p>Description: Spring Security OAuth2 Client 基于 JPA 的存储功能逻辑模块常量 </p>
 *
 * @author : gengwei.zheng
 * @date : 2024/5/19 6:17
 */
public interface LogicClientJpaConstants extends BaseConstants {

    String CLIENT_AREA_PREFIX = AREA_PREFIX + "client:";


    String REGION_OAUTH2_AUTHORIZED_CLIENT = CLIENT_AREA_PREFIX + "authorized";
    String REGION_OAUTH2_CLIENT_REGISTRATION = CLIENT_AREA_PREFIX + "registration";
}
