/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Stirrup.
 *
 * Herodotus Stirrup is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Stirrup is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.logic.client.jpa.config;

import cn.herodotus.stirrup.logic.client.jpa.processor.ClientRegistrationInitializationProcessor;
import cn.herodotus.stirrup.logic.client.jpa.service.HerodotusAuthorizedClientService;
import cn.herodotus.stirrup.logic.client.jpa.service.HerodotusClientRegistrationService;
import cn.herodotus.stirrup.logic.client.jpa.storage.JpaClientRegistrationRepository;
import cn.herodotus.stirrup.logic.client.jpa.storage.JpaOAuth2AuthorizedClientService;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;

/**
 * <p>Description: OAuth2 Client 模块配置 </p>
 *
 * @author : gengwei.zheng
 * @date : 2023/5/7 14:28
 */
@AutoConfiguration
@EntityScan(basePackages = {
        "cn.herodotus.stirrup.logic.client.jpa.entity"
})
@EnableJpaRepositories(basePackages = {
        "cn.herodotus.stirrup.logic.client.jpa.repository",
})
@ComponentScan(basePackages = {
        "cn.herodotus.stirrup.logic.client.jpa.service",
})
public class LogicClientJpaConfiguration {

    private static final Logger log = LoggerFactory.getLogger(LogicClientJpaConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- Module [OAuth2 Client JPA] Auto Configure.");
    }

    @Bean
    @ConditionalOnMissingBean
    public ClientRegistrationRepository clientRegistrationRepository(HerodotusClientRegistrationService herodotusClientRegistrationService) {
        JpaClientRegistrationRepository jpaClientRegistrationRepository = new JpaClientRegistrationRepository(herodotusClientRegistrationService);
        log.debug("[Herodotus] |- Bean [Jpa Client Registration Repository] Auto Configure.");
        return jpaClientRegistrationRepository;
    }

    @Bean
    @ConditionalOnMissingBean
    public OAuth2AuthorizedClientService oauth2AuthorizedClientService(HerodotusAuthorizedClientService herodotusAuthorizedClientService, ClientRegistrationRepository clientRegistrationRepository) {
        JpaOAuth2AuthorizedClientService jpaOAuth2AuthorizedClientService = new JpaOAuth2AuthorizedClientService(herodotusAuthorizedClientService, clientRegistrationRepository);
        log.debug("[Herodotus] |- Bean [Jpa OAuth2 Authorized Client Service] Auto Configure.");
        return jpaOAuth2AuthorizedClientService;
    }

    @Bean
    public ClientRegistrationInitializationProcessor clientRegistrationInitializationProcessor(OAuth2ClientProperties clientProperties, HerodotusClientRegistrationService clientRegistrationRepository) {
        ClientRegistrationInitializationProcessor processor = new ClientRegistrationInitializationProcessor(clientProperties, clientRegistrationRepository);
        log.debug("[Herodotus] |- Bean [Client Registration Initialization Processor] Auto Configure.");
        return processor;
    }
}
