/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.logic.client.jpa.storage;

import cn.herodotus.stirrup.core.definition.domain.base.Entity;
import cn.herodotus.stirrup.logic.client.jpa.converter.HerodotusToOAuth2AuthorizedClientConverter;
import cn.herodotus.stirrup.logic.client.jpa.converter.OAuth2ToHerodotusAuthorizedClientConverter;
import cn.herodotus.stirrup.logic.client.jpa.entity.HerodotusAuthorizedClient;
import cn.herodotus.stirrup.logic.client.jpa.service.HerodotusAuthorizedClientService;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.util.Assert;

public class JpaOAuth2AuthorizedClientService
implements OAuth2AuthorizedClientService {
    private static final Logger log = LoggerFactory.getLogger(JpaOAuth2AuthorizedClientService.class);
    private final HerodotusAuthorizedClientService herodotusAuthorizedClientService;
    private final Converter<HerodotusAuthorizedClient, OAuth2AuthorizedClient> herodotusToOAuth2AuthorizedClientConverter;

    public JpaOAuth2AuthorizedClientService(HerodotusAuthorizedClientService herodotusAuthorizedClientService, ClientRegistrationRepository clientRegistrationRepository) {
        this.herodotusAuthorizedClientService = herodotusAuthorizedClientService;
        this.herodotusToOAuth2AuthorizedClientConverter = new HerodotusToOAuth2AuthorizedClientConverter(clientRegistrationRepository);
    }

    public <T extends OAuth2AuthorizedClient> T loadAuthorizedClient(String clientRegistrationId, String principalName) {
        Assert.hasText((String)clientRegistrationId, (String)"clientRegistrationId cannot be empty");
        Assert.hasText((String)principalName, (String)"principalName cannot be empty");
        OAuth2AuthorizedClient result = this.herodotusAuthorizedClientService.findByRegisteredClientIdAndPrincipalName(clientRegistrationId, principalName).map(arg_0 -> this.herodotusToOAuth2AuthorizedClientConverter.convert(arg_0)).orElse(null);
        return (T)(ObjectUtils.isNotEmpty((Object)result) ? result : null);
    }

    public void saveAuthorizedClient(OAuth2AuthorizedClient authorizedClient, Authentication principal) {
        Assert.notNull((Object)authorizedClient, (String)"authorizedClient cannot be null");
        Assert.notNull((Object)principal, (String)"principal cannot be null");
        OAuth2ToHerodotusAuthorizedClientConverter converter = new OAuth2ToHerodotusAuthorizedClientConverter(principal);
        HerodotusAuthorizedClient herodotusAuthorizedClient = (HerodotusAuthorizedClient)((Object)converter.convert(authorizedClient));
        this.herodotusAuthorizedClientService.saveAndFlush((Entity)herodotusAuthorizedClient);
        log.debug("[Herodotus] |- Jpa OAuth2 Authorized Client Service save entity.");
    }

    public void removeAuthorizedClient(String clientRegistrationId, String principalName) {
        Assert.hasText((String)clientRegistrationId, (String)"clientRegistrationId cannot be empty");
        Assert.hasText((String)principalName, (String)"principalName cannot be empty");
        this.herodotusAuthorizedClientService.deleteByClientRegistrationIdAndPrincipalName(clientRegistrationId, principalName);
        log.debug("[Herodotus] |- Jpa OAuth2 Authorized Client Service remove entity.");
    }
}

