/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.logic.client.jpa.storage;

import cn.herodotus.stirrup.core.definition.domain.base.Entity;
import cn.herodotus.stirrup.logic.client.jpa.converter.HerodotusToOAuth2ClientRegistrationConverter;
import cn.herodotus.stirrup.logic.client.jpa.converter.OAuth2ToHerodotusClientRegistrationConverter;
import cn.herodotus.stirrup.logic.client.jpa.entity.HerodotusClientRegistration;
import cn.herodotus.stirrup.logic.client.jpa.service.HerodotusClientRegistrationService;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;

public class JpaClientRegistrationRepository
implements ClientRegistrationRepository {
    private static final Logger log = LoggerFactory.getLogger(JpaClientRegistrationRepository.class);
    private final HerodotusClientRegistrationService herodotusClientRegistrationService;
    private final Converter<ClientRegistration, HerodotusClientRegistration> oauth2ToHerodotusClientRegistrationConverter;
    private final Converter<HerodotusClientRegistration, ClientRegistration> herodotusToClientRegistrationConverter;

    public JpaClientRegistrationRepository(HerodotusClientRegistrationService herodotusClientRegistrationService) {
        this.herodotusClientRegistrationService = herodotusClientRegistrationService;
        this.oauth2ToHerodotusClientRegistrationConverter = new OAuth2ToHerodotusClientRegistrationConverter();
        this.herodotusToClientRegistrationConverter = new HerodotusToOAuth2ClientRegistrationConverter();
    }

    public ClientRegistration findByRegistrationId(String registrationId) {
        HerodotusClientRegistration herodotusClientRegistration = this.herodotusClientRegistrationService.findByRegistrationId(registrationId);
        if (ObjectUtils.isNotEmpty((Object)((Object)herodotusClientRegistration))) {
            return (ClientRegistration)this.herodotusToClientRegistrationConverter.convert((Object)herodotusClientRegistration);
        }
        return null;
    }

    public boolean saveOrUpdate(ClientRegistration clientRegistration) {
        HerodotusClientRegistration result = (HerodotusClientRegistration)this.herodotusClientRegistrationService.saveAndFlush((Entity)((HerodotusClientRegistration)((Object)this.oauth2ToHerodotusClientRegistrationConverter.convert((Object)clientRegistration))));
        return ObjectUtils.isNotEmpty((Object)((Object)result));
    }
}

