/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.logic.client.jpa.service;

import cn.herodotus.stirrup.data.crud.repository.BaseJpaRepository;
import cn.herodotus.stirrup.data.crud.service.AbstractJpaService;
import cn.herodotus.stirrup.logic.client.jpa.converter.OAuth2ToHerodotusClientRegistrationConverter;
import cn.herodotus.stirrup.logic.client.jpa.entity.HerodotusClientRegistration;
import cn.herodotus.stirrup.logic.client.jpa.repository.HerodotusClientRegistrationRepository;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.stereotype.Service;

@Service
public class HerodotusClientRegistrationService
extends AbstractJpaService<HerodotusClientRegistration, String> {
    private static final Logger log = LoggerFactory.getLogger(HerodotusClientRegistrationService.class);
    private final HerodotusClientRegistrationRepository clientRegistrationRepository;
    private final Converter<ClientRegistration, HerodotusClientRegistration> converter;

    public HerodotusClientRegistrationService(HerodotusClientRegistrationRepository clientRegistrationRepository) {
        this.clientRegistrationRepository = clientRegistrationRepository;
        this.converter = new OAuth2ToHerodotusClientRegistrationConverter();
    }

    public BaseJpaRepository<HerodotusClientRegistration, String> getRepository() {
        return this.clientRegistrationRepository;
    }

    public HerodotusClientRegistration findByRegistrationId(String registrationId) {
        HerodotusClientRegistration herodotusClientRegistration = this.clientRegistrationRepository.findByRegistrationId(registrationId);
        log.debug("[Herodotus] |- HerodotusClientRegistration Service findByRegistrationId.");
        return herodotusClientRegistration;
    }

    private List<HerodotusClientRegistration> toEntities(List<ClientRegistration> clientRegistrations) {
        return clientRegistrations.stream().map(arg_0 -> this.converter.convert(arg_0)).collect(Collectors.toList());
    }

    public boolean batchSaveOrUpdate(List<ClientRegistration> clientRegistrations) {
        if (CollectionUtils.isNotEmpty(clientRegistrations)) {
            List result = super.saveAllAndFlush(this.toEntities(clientRegistrations));
            return CollectionUtils.isNotEmpty((Collection)result);
        }
        return false;
    }
}

