/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.logic.client.jpa.service;

import cn.herodotus.stirrup.data.crud.repository.BaseJpaRepository;
import cn.herodotus.stirrup.data.crud.service.AbstractJpaService;
import cn.herodotus.stirrup.logic.client.jpa.entity.HerodotusAuthorizedClient;
import cn.herodotus.stirrup.logic.client.jpa.generator.HerodotusAuthorizedClientId;
import cn.herodotus.stirrup.logic.client.jpa.repository.HerodotusAuthorizedClientRepository;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class HerodotusAuthorizedClientService
extends AbstractJpaService<HerodotusAuthorizedClient, HerodotusAuthorizedClientId> {
    private static final Logger log = LoggerFactory.getLogger(HerodotusAuthorizedClientService.class);
    private final HerodotusAuthorizedClientRepository authorizedClientRepository;

    public HerodotusAuthorizedClientService(HerodotusAuthorizedClientRepository authorizedClientRepository) {
        this.authorizedClientRepository = authorizedClientRepository;
    }

    public BaseJpaRepository<HerodotusAuthorizedClient, HerodotusAuthorizedClientId> getRepository() {
        return this.authorizedClientRepository;
    }

    public Optional<HerodotusAuthorizedClient> findByRegisteredClientIdAndPrincipalName(String clientRegistrationId, String principalName) {
        Optional<HerodotusAuthorizedClient> result = this.authorizedClientRepository.findByClientRegistrationIdAndPrincipalName(clientRegistrationId, principalName);
        log.debug("[Herodotus] |- HerodotusAuthorizedClient Service findByRegisteredClientIdAndPrincipalName.");
        return result;
    }

    public void deleteByClientRegistrationIdAndPrincipalName(String clientRegistrationId, String principalName) {
        this.authorizedClientRepository.deleteByClientRegistrationIdAndPrincipalName(clientRegistrationId, principalName);
    }
}

