/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.logic.client.jpa.processor;

import cn.herodotus.stirrup.logic.client.jpa.service.HerodotusClientRegistrationService;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientProperties;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientPropertiesMapper;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.security.oauth2.client.registration.ClientRegistration;

public class ClientRegistrationInitializationProcessor
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger log = LoggerFactory.getLogger(HerodotusClientRegistrationService.class);
    private final OAuth2ClientProperties clientProperties;
    private final HerodotusClientRegistrationService clientRegistrationService;

    public ClientRegistrationInitializationProcessor(OAuth2ClientProperties clientProperties, HerodotusClientRegistrationService clientRegistrationService) {
        this.clientProperties = clientProperties;
        this.clientRegistrationService = clientRegistrationService;
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        ArrayList<ClientRegistration> registrations = new ArrayList<ClientRegistration>(new OAuth2ClientPropertiesMapper(this.clientProperties).asClientRegistrations().values());
        boolean success = this.clientRegistrationService.batchSaveOrUpdate(registrations);
        if (success) {
            log.info("[Herodotus] |- Successfully initialized client registration information");
        } else {
            log.error("[Herodotus] |- Client registration information initialization failed");
        }
    }
}

