/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.logic.client.jpa.entity;

import cn.herodotus.stirrup.core.definition.domain.base.AbstractEntity;
import cn.herodotus.stirrup.logic.client.jpa.generator.HerodotusAuthorizedClientId;
import com.google.common.base.MoreObjects;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.Index;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.CreationTimestamp;

@Entity
@Table(name="oauth2_authorized_client", indexes={@Index(name="oauth2_authorized_client_crid_idx", columnList="client_registration_id"), @Index(name="oauth2_authorized_client_pn_idx", columnList="principal_name")})
@IdClass(value=HerodotusAuthorizedClientId.class)
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="data:client:authorized")
public class HerodotusAuthorizedClient
extends AbstractEntity {
    @Id
    @Column(name="client_registration_id", nullable=false, length=100)
    private String clientRegistrationId;
    @Id
    @Column(name="principal_name", nullable=false, length=200)
    private String principalName;
    @Column(name="access_token_type", nullable=false, length=100)
    private String accessTokenType;
    @Column(name="access_token_value", nullable=false, columnDefinition="TEXT")
    private String accessTokenValue;
    @Column(name="access_token_issued_at", nullable=false)
    private LocalDateTime accessTokenIssuedAt;
    @Column(name="access_token_expires_at", nullable=false)
    private LocalDateTime accessTokenExpiresAt;
    @Column(name="access_token_scopes", length=1000)
    private String accessTokenScopes;
    @Column(name="refresh_token_value", columnDefinition="TEXT")
    private String refreshTokenValue;
    @Column(name="refresh_token_issued_at")
    private LocalDateTime refreshTokenIssuedAt;
    @CreationTimestamp
    @Column(name="created_at")
    private LocalDateTime createdAt;

    public String getClientRegistrationId() {
        return this.clientRegistrationId;
    }

    public void setClientRegistrationId(String clientRegistrationId) {
        this.clientRegistrationId = clientRegistrationId;
    }

    public String getPrincipalName() {
        return this.principalName;
    }

    public void setPrincipalName(String principalName) {
        this.principalName = principalName;
    }

    public String getAccessTokenType() {
        return this.accessTokenType;
    }

    public void setAccessTokenType(String accessTokenType) {
        this.accessTokenType = accessTokenType;
    }

    public String getAccessTokenValue() {
        return this.accessTokenValue;
    }

    public void setAccessTokenValue(String accessTokenValue) {
        this.accessTokenValue = accessTokenValue;
    }

    public LocalDateTime getAccessTokenIssuedAt() {
        return this.accessTokenIssuedAt;
    }

    public void setAccessTokenIssuedAt(LocalDateTime accessTokenIssuedAt) {
        this.accessTokenIssuedAt = accessTokenIssuedAt;
    }

    public LocalDateTime getAccessTokenExpiresAt() {
        return this.accessTokenExpiresAt;
    }

    public void setAccessTokenExpiresAt(LocalDateTime accessTokenExpiresAt) {
        this.accessTokenExpiresAt = accessTokenExpiresAt;
    }

    public String getAccessTokenScopes() {
        return this.accessTokenScopes;
    }

    public void setAccessTokenScopes(String accessTokenScopes) {
        this.accessTokenScopes = accessTokenScopes;
    }

    public String getRefreshTokenValue() {
        return this.refreshTokenValue;
    }

    public void setRefreshTokenValue(String refreshTokenValue) {
        this.refreshTokenValue = refreshTokenValue;
    }

    public LocalDateTime getRefreshTokenIssuedAt() {
        return this.refreshTokenIssuedAt;
    }

    public void setRefreshTokenIssuedAt(LocalDateTime refreshTokenIssuedAt) {
        this.refreshTokenIssuedAt = refreshTokenIssuedAt;
    }

    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("clientRegistrationId", (Object)this.clientRegistrationId).add("principalName", (Object)this.principalName).add("accessTokenType", (Object)this.accessTokenType).add("accessTokenValue", (Object)this.accessTokenValue).add("accessTokenIssuedAt", (Object)this.accessTokenIssuedAt).add("accessTokenExpiresAt", (Object)this.accessTokenExpiresAt).add("accessTokenScopes", (Object)this.accessTokenScopes).add("refreshTokenValue", (Object)this.refreshTokenValue).add("refreshTokenIssuedAt", (Object)this.refreshTokenIssuedAt).add("createdAt", (Object)this.createdAt).toString();
    }
}

