/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.logic.client.jpa.converter;

import cn.herodotus.stirrup.core.foundation.json.jackson2.utils.Jackson2Utils;
import cn.herodotus.stirrup.logic.client.jpa.entity.HerodotusClientRegistration;
import java.util.Collection;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.util.StringUtils;

public class OAuth2ToHerodotusClientRegistrationConverter
implements Converter<ClientRegistration, HerodotusClientRegistration> {
    public HerodotusClientRegistration convert(ClientRegistration clientRegistration) {
        HerodotusClientRegistration oauth2ClientRegistration = new HerodotusClientRegistration();
        oauth2ClientRegistration.setRegistrationId(clientRegistration.getRegistrationId());
        oauth2ClientRegistration.setClientId(clientRegistration.getClientId());
        oauth2ClientRegistration.setClientSecret(clientRegistration.getClientSecret());
        oauth2ClientRegistration.setClientAuthenticationMethod(clientRegistration.getClientAuthenticationMethod().getValue());
        oauth2ClientRegistration.setAuthorizationGrantType(clientRegistration.getAuthorizationGrantType().getValue());
        oauth2ClientRegistration.setClientName(clientRegistration.getClientName());
        oauth2ClientRegistration.setRedirectUri(clientRegistration.getRedirectUri());
        oauth2ClientRegistration.setScopes(StringUtils.collectionToCommaDelimitedString((Collection)clientRegistration.getScopes()));
        ClientRegistration.ProviderDetails providerDetails = clientRegistration.getProviderDetails();
        if (ObjectUtils.isNotEmpty((Object)providerDetails)) {
            oauth2ClientRegistration.setAuthorizationUri(providerDetails.getAuthorizationUri());
            oauth2ClientRegistration.setTokenUri(providerDetails.getTokenUri());
            oauth2ClientRegistration.setJwkSetUri(providerDetails.getJwkSetUri());
            oauth2ClientRegistration.setIssuerUri(providerDetails.getIssuerUri());
            ClientRegistration.ProviderDetails.UserInfoEndpoint userInfoEndpoint = providerDetails.getUserInfoEndpoint();
            if (ObjectUtils.isNotEmpty((Object)userInfoEndpoint)) {
                oauth2ClientRegistration.setUserInfoUri(userInfoEndpoint.getUri());
                oauth2ClientRegistration.setUserInfoAuthenticationMethod(userInfoEndpoint.getAuthenticationMethod().getValue());
                oauth2ClientRegistration.setUsernameAttributeName(userInfoEndpoint.getUserNameAttributeName());
            }
            oauth2ClientRegistration.setConfigurationMetadata(Jackson2Utils.toJson((Object)providerDetails.getConfigurationMetadata()));
        }
        return oauth2ClientRegistration;
    }
}

