/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.logic.client.jpa.converter;

import cn.herodotus.stirrup.logic.client.jpa.entity.HerodotusAuthorizedClient;
import java.time.Instant;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.dromara.hutool.core.date.DateUtil;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2RefreshToken;
import org.springframework.util.StringUtils;

public class OAuth2ToHerodotusAuthorizedClientConverter
implements Converter<OAuth2AuthorizedClient, HerodotusAuthorizedClient> {
    private final Authentication principal;

    public OAuth2ToHerodotusAuthorizedClientConverter(Authentication principal) {
        this.principal = principal;
    }

    public HerodotusAuthorizedClient convert(OAuth2AuthorizedClient authorizedClient) {
        ClientRegistration clientRegistration = authorizedClient.getClientRegistration();
        OAuth2AccessToken accessToken = authorizedClient.getAccessToken();
        OAuth2RefreshToken refreshToken = authorizedClient.getRefreshToken();
        HerodotusAuthorizedClient herodotusAuthorizedClient = new HerodotusAuthorizedClient();
        herodotusAuthorizedClient.setClientRegistrationId(clientRegistration.getRegistrationId());
        herodotusAuthorizedClient.setPrincipalName(this.principal.getName());
        herodotusAuthorizedClient.setAccessTokenType(accessToken.getTokenType().getValue());
        herodotusAuthorizedClient.setAccessTokenValue(accessToken.getTokenValue());
        herodotusAuthorizedClient.setAccessTokenIssuedAt(DateUtil.toLocalDateTime((Instant)accessToken.getIssuedAt()));
        herodotusAuthorizedClient.setAccessTokenExpiresAt(DateUtil.toLocalDateTime((Instant)accessToken.getExpiresAt()));
        if (CollectionUtils.isNotEmpty((Collection)accessToken.getScopes())) {
            herodotusAuthorizedClient.setAccessTokenScopes(StringUtils.collectionToCommaDelimitedString((Collection)accessToken.getScopes()));
        }
        if (ObjectUtils.isNotEmpty((Object)refreshToken)) {
            herodotusAuthorizedClient.setRefreshTokenValue(refreshToken.getTokenValue());
            herodotusAuthorizedClient.setRefreshTokenIssuedAt(DateUtil.toLocalDateTime((Instant)refreshToken.getIssuedAt()));
        }
        return herodotusAuthorizedClient;
    }
}

