/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.logic.client.jpa.converter;

import cn.herodotus.stirrup.core.foundation.json.jackson2.utils.Jackson2Utils;
import cn.herodotus.stirrup.logic.client.jpa.entity.HerodotusClientRegistration;
import cn.herodotus.stirrup.oauth2.core.utils.OAuth2AuthorizationUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.util.StringUtils;

public class HerodotusToOAuth2ClientRegistrationConverter
implements Converter<HerodotusClientRegistration, ClientRegistration> {
    public ClientRegistration convert(HerodotusClientRegistration clientRegistration) {
        ClientAuthenticationMethod clientAuthenticationMethod = clientRegistration.getClientAuthenticationMethod() != null ? OAuth2AuthorizationUtils.resolveClientAuthenticationMethod((String)clientRegistration.getClientAuthenticationMethod()) : null;
        Map configurationMetadata = clientRegistration.getConfigurationMetadata() != null ? Jackson2Utils.toMap((String)clientRegistration.getConfigurationMetadata()) : new HashMap();
        return ClientRegistration.withRegistrationId((String)clientRegistration.getRegistrationId()).clientId(clientRegistration.getClientId()).clientSecret(clientRegistration.getClientSecret()).clientAuthenticationMethod(clientAuthenticationMethod).authorizationGrantType(OAuth2AuthorizationUtils.resolveAuthorizationGrantType((String)clientRegistration.getAuthorizationGrantType())).clientName(clientRegistration.getClientName()).redirectUri(clientRegistration.getRedirectUri()).scope((Collection)StringUtils.commaDelimitedListToSet((String)clientRegistration.getScopes())).authorizationUri(clientRegistration.getAuthorizationUri()).tokenUri(clientRegistration.getTokenUri()).jwkSetUri(clientRegistration.getJwkSetUri()).issuerUri(clientRegistration.getIssuerUri()).userInfoUri(clientRegistration.getUserInfoUri()).userInfoAuthenticationMethod(OAuth2AuthorizationUtils.resolveAuthenticationMethod((String)clientRegistration.getUserInfoAuthenticationMethod())).userNameAttributeName(clientRegistration.getUsernameAttributeName()).providerConfigurationMetadata(configurationMetadata).build();
    }
}

