/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.logic.client.jpa.converter;

import cn.herodotus.stirrup.logic.client.jpa.entity.HerodotusAuthorizedClient;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Collections;
import java.util.Set;
import org.dromara.hutool.core.date.DateUtil;
import org.springframework.core.convert.converter.Converter;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2RefreshToken;
import org.springframework.util.StringUtils;

public class HerodotusToOAuth2AuthorizedClientConverter
implements Converter<HerodotusAuthorizedClient, OAuth2AuthorizedClient> {
    private final ClientRegistrationRepository clientRegistrationRepository;

    public HerodotusToOAuth2AuthorizedClientConverter(ClientRegistrationRepository clientRegistrationRepository) {
        this.clientRegistrationRepository = clientRegistrationRepository;
    }

    public OAuth2AuthorizedClient convert(HerodotusAuthorizedClient authorizedClient) {
        String clientRegistrationId = authorizedClient.getClientRegistrationId();
        ClientRegistration clientRegistration = this.clientRegistrationRepository.findByRegistrationId(clientRegistrationId);
        if (clientRegistration == null) {
            throw new DataRetrievalFailureException("The ClientRegistration with id '" + clientRegistrationId + "' exists in the data source, however, it was not found in the ClientRegistrationRepository.");
        }
        OAuth2AccessToken.TokenType tokenType = null;
        if (OAuth2AccessToken.TokenType.BEARER.getValue().equalsIgnoreCase(authorizedClient.getAccessTokenType())) {
            tokenType = OAuth2AccessToken.TokenType.BEARER;
        }
        String tokenValue = authorizedClient.getAccessTokenValue();
        Instant issuedAt = DateUtil.toInstant((TemporalAccessor)authorizedClient.getAccessTokenIssuedAt());
        Instant expiresAt = DateUtil.toInstant((TemporalAccessor)authorizedClient.getAccessTokenExpiresAt());
        Set scopes = Collections.emptySet();
        String accessTokenScopes = authorizedClient.getAccessTokenScopes();
        if (accessTokenScopes != null) {
            scopes = StringUtils.commaDelimitedListToSet((String)accessTokenScopes);
        }
        OAuth2AccessToken accessToken = new OAuth2AccessToken(tokenType, tokenValue, issuedAt, expiresAt, scopes);
        OAuth2RefreshToken refreshToken = null;
        String refreshTokenValue = authorizedClient.getRefreshTokenValue();
        if (refreshTokenValue != null) {
            tokenValue = refreshTokenValue;
            issuedAt = null;
            LocalDateTime refreshTokenIssuedAt = authorizedClient.getRefreshTokenIssuedAt();
            if (refreshTokenIssuedAt != null) {
                issuedAt = DateUtil.toInstant((TemporalAccessor)refreshTokenIssuedAt);
            }
            refreshToken = new OAuth2RefreshToken(tokenValue, issuedAt);
        }
        String principalName = authorizedClient.getPrincipalName();
        return new OAuth2AuthorizedClient(clientRegistration, principalName, accessToken, refreshToken);
    }
}

