/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.kernel.engine.json.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;

public class GsonUtils {
    private static final GsonBuilder GSON_BUILDER = new GsonBuilder();
    private static volatile Gson instance;

    private GsonUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Gson getInstance() {
        if (ObjectUtils.isEmpty((Object)instance)) {
            GsonBuilder gsonBuilder = GSON_BUILDER;
            synchronized (gsonBuilder) {
                if (ObjectUtils.isEmpty((Object)instance)) {
                    instance = GSON_BUILDER.create();
                }
            }
        }
        return instance;
    }

    public static JsonElement toJsonElement(String content) {
        return JsonParser.parseString((String)content);
    }

    public static JsonArray toJsonArray(String content) {
        return GsonUtils.toJsonElement(content).getAsJsonArray();
    }

    public static JsonObject toJsonObject(String content) {
        return GsonUtils.toJsonElement(content).getAsJsonObject();
    }

    public static <T> String toJson(T domain) {
        return GsonUtils.getInstance().toJson(domain);
    }

    public static <T> T toObject(String content, Class<T> valueType) {
        return (T)GsonUtils.getInstance().fromJson(content, valueType);
    }

    public static <T> T toObject(String content, Type typeOfT) {
        return (T)GsonUtils.getInstance().fromJson(content, typeOfT);
    }

    public static <T> T toList(String content, Class<T> valueType) {
        return (T)GsonUtils.getInstance().fromJson(content, new TypeToken<List<T>>(){}.getType());
    }

    public static <T> List<Map<String, T>> toListMap(String content) {
        return (List)GsonUtils.getInstance().fromJson(content, new TypeToken<List<Map<String, String>>>(){}.getType());
    }

    public static <T> Map<String, T> toMaps(String gsonString) {
        return (Map)GsonUtils.getInstance().fromJson(gsonString, new TypeToken<Map<String, T>>(){}.getType());
    }

    static {
        GSON_BUILDER.enableComplexMapKeySerialization();
        GSON_BUILDER.serializeNulls();
        GSON_BUILDER.setDateFormat("yyyy-MM-dd HH:mm:ss");
        GSON_BUILDER.disableHtmlEscaping();
    }
}

