/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.data.hibernate.spi.cache;

import cn.herodotus.stirrup.core.foundation.context.TenantContextHolder;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.dromara.hutool.crypto.SecureUtil;
import org.hibernate.cache.spi.QueryKey;
import org.hibernate.cache.spi.support.DomainDataStorageAccess;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;

public class HerodotusDomainDataStorageAccess
implements DomainDataStorageAccess {
    private static final Logger log = LoggerFactory.getLogger(HerodotusDomainDataStorageAccess.class);
    private Cache cache;

    public HerodotusDomainDataStorageAccess() {
    }

    public HerodotusDomainDataStorageAccess(Cache cache) {
        this.cache = cache;
    }

    private String secure(Object key) {
        if (key instanceof QueryKey) {
            QueryKey queryKey = (QueryKey)key;
            int hashCode = queryKey.hashCode();
            String hashCodeString = String.valueOf(hashCode);
            String secureKey = SecureUtil.md5((String)hashCodeString);
            log.trace("[Herodotus] |- SPI - Convert query key hashcode [{}] to secureKey [{}]", (Object)hashCode, (Object)secureKey);
            return secureKey;
        }
        return String.valueOf(key);
    }

    private String getTenantId() {
        String tenantId = TenantContextHolder.getTenantId();
        log.trace("[Herodotus] |- SPI - Tenant identifier for jpa second level cache is : [{}]", (Object)tenantId);
        return StringUtils.toRootLowerCase((String)tenantId);
    }

    private String wrapper(Object key) {
        String original = this.secure(key);
        String tenantId = this.getTenantId();
        String result = tenantId + ":" + original;
        log.trace("[Herodotus] |- SPI - Current cache key is : [{}]", (Object)result);
        return result;
    }

    private Object get(Object key) {
        Cache.ValueWrapper value = this.cache.get(key);
        if (ObjectUtils.isNotEmpty((Object)value)) {
            return value.get();
        }
        return null;
    }

    public boolean contains(Object key) {
        String wrapperKey = this.wrapper(key);
        Object value = this.get(wrapperKey);
        log.trace("[Herodotus] |- SPI - check is key : [{}] exist.", (Object)wrapperKey);
        return ObjectUtils.isNotEmpty((Object)value);
    }

    public Object getFromCache(Object key, SharedSessionContractImplementor session) {
        String wrapperKey = this.wrapper(key);
        Object value = this.get(wrapperKey);
        log.trace("[Herodotus] |- SPI - get from cache key is : [{}], value is : [{}]", (Object)wrapperKey, value);
        return value;
    }

    public void putIntoCache(Object key, Object value, SharedSessionContractImplementor session) {
        String wrapperKey = this.wrapper(key);
        log.trace("[Herodotus] |- SPI - put into cache key is : [{}], value is : [{}]", (Object)wrapperKey, value);
        this.cache.put((Object)wrapperKey, value);
    }

    public void removeFromCache(Object key, SharedSessionContractImplementor session) {
        String wrapperKey = this.wrapper(key);
        log.trace("[Herodotus] |- SPI - remove from cache key is : [{}]", (Object)wrapperKey);
        this.cache.evict((Object)wrapperKey);
    }

    public void evictData(Object key) {
        String wrapperKey = this.wrapper(key);
        log.trace("[Herodotus] |- SPI - evict key : [{}] from cache.", (Object)wrapperKey);
        this.cache.evict((Object)wrapperKey);
    }

    public void clearCache(SharedSessionContractImplementor session) {
        this.evictData();
    }

    public void evictData() {
        this.cache.clear();
    }

    public void release() {
        this.cache.invalidate();
    }
}

