/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.data.hibernate.tenant;

import cn.herodotus.stirrup.data.core.context.TenantContextHolder;
import java.util.Map;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.orm.jpa.HibernatePropertiesCustomizer;
import org.springframework.stereotype.Component;

@Component
public class HerodotusTenantIdentifierResolver
implements CurrentTenantIdentifierResolver<String>,
HibernatePropertiesCustomizer {
    private static final Logger log = LoggerFactory.getLogger(HerodotusTenantIdentifierResolver.class);

    public String resolveCurrentTenantIdentifier() {
        String currentTenantId = TenantContextHolder.getTenantId();
        log.trace("[Herodotus] |- Resolve Current Tenant Identifier is : [{}]", (Object)currentTenantId);
        return currentTenantId;
    }

    public boolean validateExistingCurrentSessions() {
        return true;
    }

    public void customize(Map<String, Object> hibernateProperties) {
        log.debug("[Herodotus] |- Apply hibernate properties [MULTI_TENANT_IDENTIFIER_RESOLVER]");
        hibernateProperties.put("hibernate.tenant_identifier_resolver", this);
    }
}

