/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.data.crud.service;

import cn.herodotus.stirrup.core.definition.domain.base.Entity;
import cn.herodotus.stirrup.data.crud.repository.BaseJpaRepository;
import java.io.Serializable;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;

public interface JpaReadableService<E extends Entity, ID extends Serializable> {
    public BaseJpaRepository<E, ID> getRepository();

    default public E findById(ID id) {
        return (E)((Entity)this.getRepository().findById(id).orElse(null));
    }

    default public boolean existsById(ID id) {
        return this.getRepository().existsById(id);
    }

    default public long count() {
        return this.getRepository().count();
    }

    default public long count(Specification<E> specification) {
        return this.getRepository().count(specification);
    }

    default public List<E> findAll() {
        return this.getRepository().findAll();
    }

    default public List<E> findAll(Sort sort) {
        return this.getRepository().findAll(sort);
    }

    default public List<E> findAll(Specification<E> specification) {
        return this.getRepository().findAll(specification);
    }

    default public List<E> findAll(Specification<E> specification, Sort sort) {
        return this.getRepository().findAll(specification, sort);
    }

    default public Page<E> findByPage(Pageable pageable) {
        return this.getRepository().findAll(pageable);
    }

    default public Page<E> findByPage(int pageNumber, int pageSize) {
        return this.findByPage((Pageable)PageRequest.of((int)pageNumber, (int)pageSize));
    }

    default public Page<E> findByPage(int pageNumber, int pageSize, Sort sort) {
        return this.findByPage((Pageable)PageRequest.of((int)pageNumber, (int)pageSize, (Sort)sort));
    }

    default public Page<E> findByPage(int pageNumber, int pageSize, Sort.Direction direction, String ... properties) {
        return this.findByPage((Pageable)PageRequest.of((int)pageNumber, (int)pageSize, (Sort.Direction)direction, (String[])properties));
    }

    default public Page<E> findByPage(Specification<E> specification, Pageable pageable) {
        return this.getRepository().findAll(specification, pageable);
    }

    default public Page<E> findByPage(Specification<E> specification, int pageNumber, int pageSize) {
        return this.getRepository().findAll(specification, (Pageable)PageRequest.of((int)pageNumber, (int)pageSize));
    }

    default public Page<E> findByPage(int pageNumber, int pageSize, Sort.Direction direction) {
        return this.findByPage((Pageable)PageRequest.of((int)pageNumber, (int)pageSize, (Sort.Direction)direction, (String[])new String[0]));
    }
}

