/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.cache.redisson.properties;

import cn.herodotus.stirrup.core.foundation.enums.Protocol;
import com.google.common.base.MoreObjects;
import org.apache.commons.lang3.StringUtils;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="spring.data.redisson")
public class RedissonProperties {
    private Boolean enabled = false;
    private Mode mode = Mode.SINGLE;
    private Boolean useSslConnection = false;
    private String config;
    private SingleServerConfig singleServerConfig;
    private ClusterServersConfig clusterServersConfig;
    private SentinelServersConfig sentinelServersConfig;

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Boolean getUseSslConnection() {
        return this.useSslConnection;
    }

    public void setUseSslConnection(Boolean useSslConnection) {
        this.useSslConnection = useSslConnection;
    }

    public String getProtocol() {
        return this.getUseSslConnection() != false ? Protocol.REDISS.getFormat() : Protocol.REDIS.getFormat();
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public SingleServerConfig getSingleServerConfig() {
        return this.singleServerConfig;
    }

    public void setSingleServerConfig(SingleServerConfig singleServerConfig) {
        this.singleServerConfig = singleServerConfig;
    }

    public ClusterServersConfig getClusterServersConfig() {
        return this.clusterServersConfig;
    }

    public void setClusterServersConfig(ClusterServersConfig clusterServersConfig) {
        this.clusterServersConfig = clusterServersConfig;
    }

    public SentinelServersConfig getSentinelServersConfig() {
        return this.sentinelServersConfig;
    }

    public void setSentinelServersConfig(SentinelServersConfig sentinelServersConfig) {
        this.sentinelServersConfig = sentinelServersConfig;
    }

    public boolean isExternalConfig() {
        return StringUtils.isNotBlank((CharSequence)this.getConfig());
    }

    public boolean isYamlConfig() {
        if (this.isExternalConfig()) {
            return StringUtils.endsWithIgnoreCase((CharSequence)this.getConfig(), (CharSequence)".yaml");
        }
        return false;
    }

    public boolean isJsonConfig() {
        if (this.isExternalConfig()) {
            return StringUtils.endsWithIgnoreCase((CharSequence)this.getConfig(), (CharSequence)".json");
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("enabled", (Object)this.enabled).add("mode", (Object)this.mode).add("config", (Object)this.config).toString();
    }

    public static enum Mode {
        SINGLE,
        SENTINEL,
        CLUSTER;

    }
}

